#
# type CELL
#

CELL[BASE] := 'POLYHEDRON';
#CELL[DOM]  := 'PCOMPLEX';

`type/CELL` := proc(x)
  op(0, x) = OBJ and op(1, x) = 'CELL'
end;

`type/POLYHEDRON` := proc(x)
  op(0, x) = OBJ and member(op(1, x), {'POLYHEDRON', 'CELL'})
end;

CELL[_print] := proc(d::posint, l::list, r::list, sat::list,
                  eq::list, ineq::list, sat2::list, nr::integer)
  if nr = 0 and l = []
    then 'CELL'(d-1, d-nops(eq)-1, nops(r), nops(ineq))
    else 'CELL'(d-1, d-nops(eq)-1, nops(l),
           [nops(r)-abs(nr), abs(nr)],
           &?(nr > 0, nops(ineq), [nops(ineq)-1]))
  fi
end;

CELL[NEW] := proc(C::POLYHEDRON, F)
#  OBJ(THIS, op(2..POLYHEDRON_NOPS, C), F)
  OBJ(THIS, op(2..POLYHEDRON_NOPS, C), table([0 = F]))
end;

CELL[`convert/CONE`] := proc(P)
local C, PC, s1, s2;
  C := POLYHEDRON['`convert/CONE`'](args);
  PC := CELL['domain'](P);
  if FAN_lines(PC) = FAIL
    then C
    else FANCONE[NEW](C, 'PCOMPLEX['`convert/FAN`']'(PC))
  fi
end;

#
# copy
#

COPYNEWENTRIES(FANCONE, CELL);
COPYNEWENTRIES(POLYHEDRON, CELL);
