#
# definitions for type CFACE
#

CFACE[DOM] := 'CONE';

`type/CFACE` := proc(x)
  op(0, x) = OBJ and OBJ_TYPE(x) = 'CFACE'
end;

CFACE[raynos] := proc(F)
  if nargs > 1
    then ERRORnargs
    else Raynos(F)
  fi
end;

CFACE[hspacenos] := proc(F)
  if nargs > 1
    then ERRORnargs
    else Hspacenos(F)
  fi
end;

#
# functions for CFACE
#

CFACE_rays := proc(F)
local r, i;
  if nargs > 1 then ERRORnargs fi;
  r := Rays(Domain(F));
  [ seq(r[i], i = Raynos(F)) ]
end;

CFACE[hspaces] := proc(F)
local ineq, i;
  if nargs > 1 then ERRORnargs fi;
  ineq := Hspaces(Domain(F));
  [ seq(ineq[i], i = Hspacenos(F)) ]
end;

CFACE[dim] := proc(F)
  if nargs > 1
    then ERRORnargs
    else nops(Lines(Domain(F)))+CFACE['rank'](F)
  fi
end;

CFACE[ispointed] := proc(F)
  if nargs > 1
    then ERRORnargs
    else Ispointed(Domain(F))
  fi
end;

CFACE[isregular] := eval(CONE[isregular]);

CFACE[dual] := proc(F)
local C;
  if nargs > 1 then ERRORnargs fi;
  C := op(CFACE_OP_domain, F);
  CFACE[NEW](op(CFACE_OP_hspacenos, F),
             op(CFACE_OP_raynos, F),
             CONE['dual'](C),
             Ambientdim(C)-nops(Lines(C))-nops(Hplanes(C))-CFACE_corank(F))
end;

#
# conversions
#

CFACE[`convert/CONE`] := eval(CFACE[DOMTYPE]);

CFACE[`convert/PFACE`] := proc(f)
local C, P, f2;
  C := Domain(f);
  if nargs > 1
    then ERRORnargs
  elif Ambientdim(C) = 0
    then ERRORdim0
  fi;
  P := OBJ_TYPE(C)[`convert/POLYHEDRON`](C);

  f2 := &?(Rays(P) = Rays(C),
             # nothing has changed (not even the order of the rays)
           PFACE[NEW](Raynos(f), Hspacenos(f), P, CFACE_corank(f)),
           PFACE['_dual'](CONE['support'](Dual(P), op(CFACE['hspaces'](f))),
                          userinfo(3, CFACE, `computing supporting face`)));
  if raynos_isaffine(Raynos(f2), NRays(P))
    then f2
    else POLYHEDRON['minimal'](P)
  fi
end;

CFACE[`convert/affine`] := proc(f)
local C, P;
  C := Domain(f);
  P := traperror(OBJ_TYPE(C)[`convert/affine`](C, args[2..-1]));
  if P = lasterror
    then ERROR(lasterror)
    else PFACE[NEW](Raynos(f) union {nops(Rays(P))}, Hspacenos(f),
                    P, CFACE_corank(f))
      # the apex is inserted as last "ray"
  fi
end;

#
# preimage
#

CFACE[preimage] := proc(f, A::{mat, rational, real_infinity})
# not efficient if A is invertible!
local C, C2;
  C := Domain(f);
  C2 := traperror(OBJ_TYPE(C)['preimage'](C, args[2..-1]));
  if C2 = lasterror
    then ERROR(lasterror)
  elif type(A, mat)
    then CFACE['_dual'](CONE['support'](Dual(C2),
                                        op(matmatmul(transpose(A),
                                                     CFACE['hspaces'](f)))))
  elif type(A, rational) and A <> 0
    then subsop(CFACE_OP_domain = C2, f)
    else # A = 0 or type(A, real_infinity)
      CONE['maximal'](C2)
  fi
end;

CFACE[relint] := proc(F)
local r;
  r := CFACE_rays(F);
  if nargs > 1
    then ERRORnargs
  elif r = []
    then [0$ambientdim(F)]
    else reducevec(`+`(op(r)))
  fi
end;

#
# cartesian product
#

# also for PFACE ???

CFACE[`&x`] := proc()
local Fl, Cl, r, h, rn, hn, i;
  Fl := [args];
  if not type(Fl, list(THIS)) then ERRORillegalcomb fi;

  Cl := map(CFACE['domain'], Fl);
  r := {}; h := {}; rn := 0; hn := 0;
  for i to nops(Fl) do
    r := r union map(`+`, Raynos(Fl[i]), rn);
    h := h union map(`+`, Hspacenos(Fl[i]), hn);
    rn := rn+nops(Rays(Cl[i]));
    hn := hn+nops(Hspaces(Cl[i]));
  od;

  THIS[NEW](r, h, &?(nargs = 0, zerocone(0), THIS[DOM][`&x`](op(Cl))))
  # we use THIS[DOM][`&x`] to allow for FANCONEs
end;
