# internal dualising keeping type and additional arguments
# this is relevant for polyhedra and new types build from these two

Dual := proc(C)
  OBJ(op(OBJ_OP_TYPE, C),
      op(CONE_OP_ambientdim, C),
      op(CONE_OP_hplanes, C),
      op(CONE_OP_hspaces, C),
      op(CONE_OP_incidentrays, C),
      op(CONE_OP_lines, C),
      op(CONE_OP_rays, C),
      op(CONE_OP_incidentfacets, C),
      op(CONE_NOPS+1..-1, C))
end;

#
# functions
#

CONE[codim] := proc(C)
  if nargs > 1
    then ERRORnargs
    else Codim(C)
  fi
end;

CONE[dim] := proc(C)
  if nargs > 1
    then ERRORnargs
    else THIS['ambientdim'](C)-Codim(C)
  fi
end;

Rays_set := proc(C)
option inline;
  convert(Rays(C), set)
end;

#
# intersection
#

intersection := proc()
# args: rays (= halfspaces) and/or lines (= hyperplanes)
#       and/or cones in any order, OR
#       affhplanes and/or affhspaces and/or polyhedra
local al, Cl, ineqs, eqs, n, L;
  al := [ args ];
  if al = []
    then ERRORrlcp
  elif type(al, list({ray, line, CONE}))
    then
      eqs   := map(reduceqvec, map2(op, 1, select(type, al, line)));
      ineqs := map(reduceqvec, select(type, al, ray));
      Cl := select(type, al, CONE);

      L := [ op(eqs), op(ineqs) ];
      n := &?(Cl = [], nops(L[1]), Ambientdim(Cl[1]));
      if andmap(proc(x) Ambientdim(x) = n end, Cl) and
         (L = [] or (nops(L[1]) = n and type(L, listlist)))
        then Intersection(n, Cl, eqs, ineqs)
        else ERRORnotsamespace
      fi
  elif type(al, list({affhplane, affhspace, POLYHEDRON}))
    then
      eqs   := map(affh2ray, select(type, al, affhplane));
      ineqs := map(affh2ray, select(type, al, affhspace));
      Cl := select(type, al, POLYHEDRON);

      L := [ op(eqs), op(ineqs) ];
      n := &?(Cl = [], nops(L[1]), Ambientdim(Cl[1]));
      if andmap(proc(x) Ambientdim(x) = n end, Cl) and
	     (L = [] or (nops(L[1]) = n and type(L, listlist)))
        then POLYHEDRON['_intersection'](n, Cl, eqs, ineqs)
        else ERRORnotsamespace
      fi
    else
      ERRORrlcp
  fi
end;

CONE['polar'] := proc(C)
  if nargs > 1
    then ERRORnargs
    else THIS['image'](THIS['dual'](C), -1)
  fi
end;

CONE[`&=`] := proc(C1, C2)
  if nargs > 2
    then ERRORnargs
  elif hasnotBASE(C2, THIS)
    then ERRORillegalcomb
    else Ambientdim(C1) = Ambientdim(C2)
         and Rays_set(C1) = Rays_set(C2) and Lines(C1) = Lines(C2)
  fi
end;

CONE[isface] := proc(C1, C2, F::name)
local r1, F2;
  if nargs > 3
    then ERRORnargs
  elif hasnotBASE(C2, THIS)
    then ERRORillegalcomb
  elif Ambientdim(C1) <> Ambientdim(C2)
    then ERRORnotsamespace
  fi;

  r1 := Rays_set(C1);
  if r1 = {} and THIS[BASE] = 'POLYHEDRON'
    then
      if nargs = 3 then F := POLYHEDRON['minimal'](C2) fi;
      true
  elif Lines(C1) = Lines(C2) and r1 subset Rays_set(C2)
    then
      F2 := CONE['support'](C2, op(r1));
      if nargs = 3
	then
	  if THIS[BASE] = 'POLYHEDRON'
	    then F := subsop(OBJ_OP_TYPE = 'PFACE', F2)
	    else F := F2
	  fi
      fi;
      F2 <> FAIL and CFACE_rays_set(F2) = r1
    else
      false
  fi
end;

CONE[`&<`] := proc()
  THIS[`&<=`](args) and not THIS[`&=`](args)
end;

CONE[`&<=`] := proc(C1, C2)
local l1, l2, nl2;
  if nargs > 2
    then ERRORnargs
  elif hasnotBASE(C2, THIS)
    then ERRORillegalcomb
  elif Ambientdim(C1) <> Ambientdim(C2)
    then ERRORnotsamespace
  fi;

  l1 := Lines(C1);
  l2 := Lines(C2);
  nl2 := nops(l2);

  nops(Hplanes(C1)) >= nops(Hplanes(C2)) and
# is it better to compare ranks of hplanes as well?
  (l1 = l2 or (nops(l1) <= nl2 and linrank([op(l2), op(l1)]) <= nl2)) and
  andmap(proc(x) contains_ray(C2, x) end, Rays(C1))
end;

CONE[arecompatible] := proc(C1, C2, C::name)
local CI, P;
  if nargs > 3
    then ERRORnargs
  elif hasnotBASE(C2, THIS)
    then ERRORillegalcomb
  elif Ambientdim(C1) <> Ambientdim(C2)
    then ERRORnotsamespace
  fi;

  if Lines(C1) = Lines(C2) or THIS[BASE] = 'POLYHEDRON'
    then
      CI := THIS['_intersection'](Ambientdim(C1), [C1, C2], [], []);
      if nargs = 3 then C := CI fi;
      THIS['isface'](CI, C1) and THIS['isface'](CI, C2)
    else
      false
  fi
end;

CONE[support] := proc(C)
local eqs, ineqs, rl, w, c, v, i, hn, ok;
  rl := [args[2..-1]];
  if rl = []
    then RETURN(THIS['minimal'](C))
  elif not type(rl, list(ray))
    then ERRORtype
  fi;

  rl := &?(THIS[BASE] = 'CONE', map(reduceqvec, rl), map(homog, rl, 1));

  if Ambientdim(C) <> nops(rl[1]) or not type(rl, listlist)
    then ERRORnotsamespace
  fi;

  eqs := Hplanes(C);
  for v in rl do
    if ormap(proc(x) Dotprod(x, v) <> 0 end, eqs)
      then RETURN(FAIL)
    fi
  od;

  ineqs := Hspaces(C);
  hn := {};
  for i to nops(ineqs) do
    w := ineqs[i];
    ok := true;
    for v in rl do
      c := Dotprod(v, w);
      if c < 0
        then RETURN(FAIL)   # ERRORnotcontray
      elif c > 0
        then ok := false
      fi
    od;
    if ok then hn := hn union { i } fi
  od;
  THIS[EL]['_hspacenos2face'](C, hn)
end;

#
# testing
#

$define Ispointed(C)	Lines(C) = []

CONE[ispointed] := proc(C)
  if nargs > 1
    then ERRORnargs
    else evalb(Ispointed(C))
  fi
end;

CONE[isfulldim] := proc(C)
  if nargs > 1
    then ERRORnargs
    else evalb(Hplanes(C) = [])
  fi
end;

CONE[issimplicial] := proc(C)
  if nargs > 1
    then ERRORnargs
    else Ispointed(C) and nops(Rays(C)) = Dim(C)
  fi
end;

CONE[issimplicial1] := proc(C)
local d1;
  d1 := Dim(C)-1;
  if nargs > 1
    then ERRORnargs
    else Ispointed(C) and andmap(proc(x) nops(x) = d1 end, Incidentrays(C))
  fi
end;

CONE[issimple] := proc(C)
  if nargs > 1
    then ERRORnargs
    else THIS['issimplicial1'](Dual(C))
  fi
end;

# conversion

CONE[`convert/CONE`] := proc(C)
  if nargs > 1
    then ERRORnargs
    else OBJ('CONE', op(2..CONE_NOPS, C))
  fi
end;

#
# faces
#

CONE[maximal] := proc(C)
  if nargs > 1
    then ERRORnargs
    else THIS[EL][NEW]({$1..nops(Rays(C))}, {}, C, 0)
  fi
end;

CONE[minimal] := proc(C)
  if nargs > 1
    then ERRORnargs
    else THIS[EL][NEW]({}, {$1..nops(Hspaces(C))}, C)
  fi
end;

# CONE[edges] moved to cone.mt
# how should one call it for polyhedra?

CONE[_edges] := proc(C)
local sat, i, d;
  if nargs > 1 then ERRORnargs fi;
  sat := Incidentfacets(C);
  d := Dim(C)-nops(Lines(C))-1;
  [ seq(THIS[EL][NEW]({i}, sat[i], C, d),
        i = &?(THIS = 'CONE', 0, abs(NRays(C)))+1..nops(sat)) ]
end;

#  CONE[facechain] := proc(C)
#    if nargs > 1
#      then ERRORnargs
#      else [THIS[EL][`_faceseq`](C, THIS['minimal'](C), THIS['maximal'](C))]
#    fi
#  end;

CONE[fvector] := proc(C)
# not very efficient
# better use Dehn-Sommerville relations for simplicial/simple polytopes!
  if nargs > 1
    then ERRORnargs
    else map(nops, THIS['faces'](C))
  fi
end;

CONE[faces] := proc(C)
local ld, d, ad, Ft, i, k, L;
  if nargs > 1 then ERRORnargs fi;
  ld := nops(Lines(C));
  d := Dim(C);
  ad := Ambientdim(C);
  Ft := array(0..ad, [[]$ad+1]);

  # type test important for polyhedra
  Ft[`&?`(THIS[BASE] = 'CONE', ld, 0)] := [THIS['minimal'](C)];
  Ft[d] := [THIS['maximal'](C)];
  if ld < d-1
    then # implicit type test important for polyhedra
     Ft[ld+1] := THIS['_edges'](C);
     Ft[d-1]  := THIS['facets'](C)
  fi;
  for k from ld+2 to d-2 do
    userinfo(3, THIS, `face dimension`, k);
    Ft[k] := map2(THIS[EL]['_hspacenos2face'], C,
                  convert({seq(op(succhspacenos(C, i)), i = Ft[k-1])}, list))
# [ seq(hspacenos2face(C, j),
#                    j = { seq(op(succhspacenos(C, i)), i = Ft[k-1]) }) ]
  od;

  if THIS[BASE] = 'CONE'
    then eval(Ft)
    else shiftarray(Ft)
  fi
end;

#
# incidence matrix
#

CONE[incidencematrix] := proc(C)
local i, j, ir, irn;
  if nargs > 1 then ERRORnargs fi;
  ir := Incidentrays(C);
  irn := &?(THIS = 'CONE' or NRays(C) >= 0, nops(ir), nops(ir)-1);
  array(sparse, 1..irn, 1..nops(Rays(C)),
        [seq(seq((i, j) = 1, j = ir[i]), i = 1..irn)])
end;

#
# for FAN/PCOMPLEX
#

CONE[boundary] := proc(C::{CONE1, POLYHEDRON1})
  if nargs > 1
    then ERRORnargs
    else THIS[POSDOM]['_purefan'](map(THIS[EL][DOMTYPE], THIS['facets'](C)),
                                  Lines(C), Hplanes(C), Rays(C))
  fi
end;

CONE[skeleton] := eval(SWITCH2FAN);

CONE[traverse] := eval(SWITCH2FAN);

CONE[traverse2] := eval(SWITCH2FAN);

CONE[flagf] := eval(SWITCH2FAN);

CONE[flagh] := eval(SWITCH2FAN);
