#
# error messages
#

macro(ERRORnargs        = ERROR("too many arguments"));
macro(ERRORtype         = ERROR("illegal argument type(s)"));
macro(ERRORsamedomain   = ERROR("arguments must belong to the same domain"));
macro(ERRORillegalcomb  = ERROR("illegal combination of argument types"));
macro(ERRORnotsamespace = ERROR("arguments must lie in the same space"));
macro(ERRORraylinecone  = ERROR("arguments must be rays, lines or cones"));
macro(ERRORarlp         = ERROR("arguments must be (affine) rays, lines \
or cones"));
macro(ERRORrlcp         = ERROR("arguments must be (rays, lines or cones), \
or ((affine) rays, lines or polyhedra)"));
macro(ERRORcone         = ERROR("arguments must be cones"));
macro(ERRORpoly         = ERROR("arguments must be polyhedra"));
macro(ERRORnotcontray   = ERROR("cone must contain the given ray(s)"));
macro(ERRORwrongmap     = ERROR("ambient dimension and map do not match"));
macro(ERRORfacecontain  = ERROR("one face must contain the other"));
macro(ERRORambientdim_0 = ERROR("cannot determine ambient dimension"));
macro(ERRORambientdim0  = ERROR("cannot determine ambient dimension, \
please use a Matrix"));
macro(ERRORcompatible   = ERROR("arguments must be compatible"));
macro(ERRORposint       = ERROR("arguments must be of type posint"));
macro(ERRORweights      = ERROR("weights must be of type integer"));
macro(ERRORfancone      = ERROR("arguments must be fancones"));
macro(ERRORconstruct    = ERROR("cannot construct polyhedron from the given data"));
macro(ERRORppointed     = ERROR("polyhedron must be pointed"));
macro(ERRORprational    = ERROR("polyhedron must be rational"));
macro(ERRORlineality    = ERROR("argument has no lineality space"));
macro(ERRORdim23        = ERROR("argument must lie in 2-space or 3-space"));
macro(ERRORdim0         = ERROR("argument must not lie in 0-space"));

#
# warnings
#

macro(WARNINGnotaffine = WARNING("no affine point specified"));
