FANCONE[domain] := proc(C)
#  FANCONE_domain(C)
local T, d;
  T := FANCONE_domain(C);
  if nargs > 1
    then ERRORnargs
  elif op(0, T[0]) = OBJ
    then T[0]
    else T[0] := eval(T[0])
  fi
end;

FANCONE[`&<=`] := proc(C1, C2)
  if type(C2, THIS) and FANCONE_domain(C1) = FANCONE_domain(C2)
    then
      Rays_set(C1) subset Rays_set(C2)
    else
      userinfo(2, THIS, 'calling', THIS[BASE][`&<=`]);
      THIS[BASE]['`&<=`'](C1, C2)
  fi
end;

FANCONE[minimum] := proc(C1)
# optional further args: C2, ..., Cn::FANCONE
local F, Cl, C, r, rs;
  Cl := [args];
  if not type(Cl, list(THIS)) then ERRORtype fi;
  F := FANCONE['domain'](C1);
  if ormap(proc(x) FANCONE['domain'](x) <> F end, Cl)
    then ERRORsamedomain
  fi;
  C := Cl[findmax(CONE['codim'], Cl)];
  r := Rays(C);
  rs := `intersect`(op(map(Rays_set, Cl)));
  THIS[NEW](THIS[EL][DOMTYPE](THIS[EL]['_raynos2face'](C,
                                                       select(proc(x) member(r[x], rs) end, {$1..nops(r)}))),
            F)
end;

FANCONE[arecompatible] := proc(C1, C2, C::name)
  if nargs > 3
    then ERRORnargs
  elif hasnotBASE(C2, THIS)
    then ERRORtype
  elif type(C2, THIS) and FANCONE['domain'](C1) = FANCONE['domain'](C2)
    then
      if nargs = 3 then C := THIS['minimum'](C1, C2) fi;
      true
    else
      userinfo(2, THIS, 'calling', THIS[BASE][arecompatible]);
      THIS[BASE]['arecompatible'](args)
  fi
end;

FANCONE[preimage] := proc(C)
local s1, s2;
  THIS[NEW](THIS[BASE]['preimage'](args),
            subs([s1 = THIS[DOM][METHOD], s2 = THIS['domain']],
                 s1(s2(C), args[2..-1])))
end;

# FANCONE[`&x`] := proc()
# local C, Cl, s1, s2;
#   C := THIS[BASE][`&x`](args);
#   Cl := [args];
#   if type(Cl, list(THIS))
#     then THIS[NEW](C, subs([s1 = THIS[DOM][`&x`], s2 = THIS['domain']],
# 			   s1(op(map(s2, Cl)))))
#     else C
#   fi
# end;
