#
# type PFACE
#

PFACE[DOM] := 'POLYHEDRON';

`type/PFACE` := proc(x)
  op(0, x) = OBJ and OBJ_TYPE(x) = 'PFACE'
end;

`type/PFACE1` := proc(x)
  `type/PFACE`(x) and CFACE_rays(x) <> []
end;

PFACE[_print] := eval(CFACE[_print]);

PFACE[vertices] := proc(F)
  if nargs > 1
    then ERRORnargs
    else map(affine, select(Isaffine, CFACE_rays(F)))
  fi
end;

PFACE[rays] := proc(F)
  if nargs > 1
    then ERRORnargs
    else map(affine, remove(Isaffine, CFACE_rays(F)))
  fi
end;

PFACE[dim] := proc(F)
  if nargs > 1
    then ERRORnargs
  elif Raynos(F) = {}
    then -1 # the empty face does not contain the lineality space!
    else CFACE['dim'](F)-1
  fi
end;

PFACE[isempty] := proc(F)
  if nargs > 1
    then ERRORnargs
    else evalb(Raynos(F) = {})
  fi
end;

PFACE[isbounded] := proc(F)
local P, rn;
  if nargs > 1 then ERRORnargs fi;
  P := Domain(F);
  rn := Raynos(F);
  rn = {} or (Lines(P) = [] and min(op(rn)) > abs(NRays(P)))
end;

PFACE[dual] := proc(f)
  if nargs > 1
    then ERRORnargs
    else CFACE['`convert/PFACE`'](CFACE['dual'](f))
  fi
end;

PFACE[`convert/POLYHEDRON`] := eval(PFACE[DOMTYPE]);

PFACE[relint] := proc(F)
  if nargs > 1
    then ERRORnargs
    else affine(CFACE['relint'](F))
  fi
end;

PFACE[`convert/CFACE`] := proc(f)
local P;
  if nargs > 1 then ERRORnargs fi;
  P := Domain(f);
  CFACE[NEW](Raynos(f), Hspacenos(f),
             OBJ_TYPE(P)['`convert/CONE`'](P), CFACE_corank(f))
end;

#
# volume
#

`face/volume/volob` := proc(F)
option remember;
global `face/volume/vertices`;
local rn, n, h, FL, vi, BL, V, B, BV, OB, v, i;
  rn := Raynos(F);
  if nops(rn) > 2
    then
      FL := PFACE['pred'](F);
      vi := op(1, Raynos(F));
      v  := `face/volume/vertices`[vi];
      BL := remove(proc(f) member(vi, Raynos(f)) end, FL);
      V  := 0;
      for B in BL do
        BV, OB := `face/volume/volob`(B);
        n := v-`face/volume/vertices`[op(1, Raynos(B))];
        n := `+`(n, seq(Dotprod(n, i[1])*i[1]*i[2], i = OB));
        h := Dotprod(n, n);
        V := V+BV*sqrt(h)
      od;
      simplify(V, sqrt)/(nops(OB)+1), [op(OB), [n, -1/h]]
  elif nops(rn) = 2
    then
      n := `face/volume/vertices`[op(2, rn)]-`face/volume/vertices`[op(1, rn)];
      h := Dotprod(n, n);
      sqrt(h), [[n, -1/h]]
    else
      nops(rn), []
  fi
end;

PFACE[volume] := proc(F)
local V;
global `face/volume/volob`, `face/volume/vertices`;
  if nargs > 1
    then ERRORnargs
  elif PFACE['isbounded'](F)
    then # this computation is correct only for bounded faces
      `face/volume/vertices` := POLYHEDRON['vertices'](Domain(F));
      V := `face/volume/volob`(F)[1];
      `face/volume/vertices` := NULL;
      forget(`face/volume/volob`);
      V
    else infinity
  fi
end;

PFACE[surface] := proc(F)
local rn, P, V, FF;
global `face/volume/volob`, `face/volume/vertices`;
  P := Domain(F);
  rn := nops(Raynos(F));
  if nargs > 1
    then ERRORnargs
  elif PFACE['isbounded'](F) or rn = 1 or (rn = 2 and Lines(P) = [])
  # If an unbounded polyhedron has a bounded surface, it is either an affine
  # subspace (1 vertex, 0 rays) or a single affine ray (1 vertex, 1 ray, no
  # lines).
    then # this computation is correct only for faces with bounded facets
      `face/volume/vertices` := POLYHEDRON['vertices'](P);
      V := `+`(seq(`face/volume/volob`(FF)[1], FF = PFACE['pred'](F)));
      forget(`face/volume/volob`);
      `face/volume/vertices` := NULL;
      simplify(V, sqrt)
    else infinity
  fi
end;

#
# copy from CFACE to PFACE
#

COPYNEWENTRIES(CFACE, PFACE);
