#
# MAPLE TYPES
#

#
# procedure
#

$define procedure_OP_remembertable	4
$define procedure_remembertable(f)	op(procedure_OP_remembertable, eval(f))
$define  forget(f)	f := subsop(procedure_OP_remembertable = NULL, eval(f))
  # clears the remember table of a procedure

#
# general type OBJ
#

macro(OBJ = '_OBJ');
$define OBJ_OP_TYPE    1
$define OBJ_TYPE(x)    op(OBJ_OP_TYPE, x)

#
# common definitions for types CONE and POLYHEDRON
#

$define CONE_NOPS		8
$define CONE_OP_ambientdim	2
$define CONE_OP_lines		3
$define CONE_OP_rays		4
$define CONE_OP_incidentfacets	5
$define CONE_OP_hplanes		6
$define CONE_OP_hspaces		7
$define CONE_OP_incidentrays	8

$define Ambientdim(C)		op(CONE_OP_ambientdim, C)
$define Rays(C)			op(CONE_OP_rays, C)
$define Lines(C)		op(CONE_OP_lines, C)
$define Incidentfacets(C)	op(CONE_OP_incidentfacets, C)
$define Hplanes(C)		op(CONE_OP_hplanes, C)
$define Hspaces(C)		op(CONE_OP_hspaces, C)
$define Incidentrays(C)		op(CONE_OP_incidentrays, C)
$define Codim(C)		nops(Hplanes(C))

#
# type polyhedron
#

$define POLYHEDRON_NOPS		9
$define POLYHEDRON_OP_nrays	9

$define NRays(P)		op(POLYHEDRON_OP_nrays, P)

#
# common definitions for types CFACE and PFACE
#

$define CFACE_NOPS		5
$define CFACE_OP_raynos		2
$define CFACE_OP_hspacenos	3
$define CFACE_OP_domain		4
$define CFACE_OP_corank		5

$define Raynos(F)		op(CFACE_OP_raynos, F)
$define Hspacenos(F)		op(CFACE_OP_hspacenos, F)
$define Domain(F)		op(CFACE_OP_domain, F)
$define CFACE_corank(F)		op(CFACE_OP_corank, F)

$define CFACE_rays_set(f)	convert(CFACE_rays(f), set)

#
# common definitions for types FAN and PCOMPLEX
#

$define FAN_NOPS		6
$define FAN_OP_ambientdim	2
$define FAN_OP_lines		3
$define FAN_OP_rays		4
$define FAN_OP_hplanes		5
$define FAN_OP_maximal_array		6

$define FAN_ambientdim(F)	op(FAN_OP_ambientdim, F)
$define FAN_lines(F)		op(FAN_OP_lines, F)
$define FAN_rays(F)		op(FAN_OP_rays, F)
$define FAN_hplanes(F)		op(FAN_OP_hplanes, F)
$define FAN_maximal_array(F)		op(FAN_OP_maximal_array, F)

#
# common definitions for types FANCONE and CELL
#

$define FANCONE_NOPS       10
$define FANCONE_OP_domain  10

$define FANCONE_domain(F)  op(FANCONE_OP_domain, F)

#
# BASIC TYPES
#

#
# affine ray
#
macro(affray = ray);
`type/ray` := specfunc(vec, 'ray');

#
# ray
#
$define ray   vec
`type/vec`  := { list(rational), 'vector'(rational), 'Vector'(rational) };

#
# line
#
`type/line` := specfunc(ray, 'line');

#
# matrix
#

`type/mat` := {[], 'matrix'(rational), 'Matrix'(rational)};

#
# affine hyperplane and halfspace
#

`type/affhplane` := {ray  = rational, rational  = ray};
`type/affhspace` := {ray <= rational, rational <= ray};

#
# OTHER TYPES
#

#
# MODZ
#

$define MODZ_NOPS      		3
$define MODZ_OP_rank		2
$define MODZ_OP_torsion		3

$define MODZ_rank(M)		op(MODZ_OP_rank, M)
$define MODZ_torsion(M)		op(MODZ_OP_torsion, M)

$define MODZ_0			MODZ['_zero']

#
# MODQ
#

$define MODQ	CONVEX
