`CFACE/listrays` := proc(A, rn)
local i;
  [seq(A[i], i = rn)]
end;

CFACE[NEW] := proc(rn, hn, C, rk::nonnegint)
# rk is the corank
  OBJ(THIS, rn, hn, C,
      &?(nargs = 3,
	 &?(nops(rn) < nops(hn),
	    Ambientdim(C)-nops(Lines(C))-nops(Hplanes(C))
	      -&?(nops(rn) <= 3,
	          nops(rn),
	          linrank(`CFACE/listrays`(Rays(C), rn, userinfo(3, THIS, `computing rank`)))),
	    &?(nops(hn) <= 3,
	       nops(hn),
	       linrank(`CFACE/listrays`(Hspaces(C), hn, userinfo(3, THIS, `computing corank`))))),
	 rk))
end;

# NEWFACE := proc(rn, hn, C)
#   OBJ(OBJ_TYPE(C)[EL], rn, hn, C)
# end;

CFACE[_print] := proc(rn::set, hn::set)
  THIS(nops(rn), nops(hn))
end;

CFACE[domain] := proc(F)
  if nargs > 1
    then ERRORnargs
    else Domain(F)
  fi
end;

raynos_isaffine := proc(rn::set, nr::integer)
# the empty face of a polyhedron (rn = {}) is considered affine!
  max(op(rn)) > abs(nr) or rn = {}
end;

CFACE[_dual] := proc(F)
# internal dualising keeping type and additional arguments
# this is relevant for polyhedra and new types build on top of cones/polyhedra
local C;
  C := Domain(F);
  THIS[NEW](op(CFACE_OP_hspacenos, F),
            op(CFACE_OP_raynos, F),
            Dual(C),
            Ambientdim(C)-nops(Lines(C))-nops(Hplanes(C))-CFACE_corank(F))
end;

#
# functions for faces
#

CFACE[ambientdim] := proc(F)
local C;
  if nargs > 1
    then ERRORnargs
    else
      C := Domain(F);
      THIS[DOM]['ambientdim'](C)
  fi
end;

CFACE[rank] := proc(F)
local C;
  if nargs > 1
    then ERRORnargs
    else
      C := Domain(F);
      Ambientdim(C)-nops(Lines(C))-nops(Hplanes(C))-CFACE_corank(F)
  fi
end;

CFACE[corank] := proc(F)
  if nargs > 1
    then ERRORnargs
    else CFACE_corank(F)
  fi
end;

CFACE[codim] := proc(F)
  if nargs > 1
    then ERRORnargs
    else nops(Hplanes(Domain(F)))+CFACE_corank(F)
  fi
end;

# we can test equality of faces as structural equality

CFACE[`&=`] := () -> evalb(`=`(args));

CFACE[`&<`] := proc() not `=`(args) and THIS[`&<=`](args) end;

CFACE[`&<=`] := proc(F1, F2)
  if nargs > 2
    then ERRORnargs
  elif not type(F2, THIS)
    then ERRORillegalcomb
  elif Domain(F1) <> Domain(F2)
    then ERRORsamedomain
    else Raynos(F1) subset Raynos(F2)
  fi
end;

#isproperface := proc(F1::face, F2::face)
#  evalb(`face/&<=`(F1, F2) and F1 <> F2)
#end;

# isfacet
CFACE[`&<<`] := proc(F1, F2)
  if nargs > 2
    then ERRORnargs
  elif not type(F2, THIS)
    then ERRORillegalcomb
  elif Domain(F1) <> Domain(F2)
    then ERRORsamedomain
    else CFACE_corank(F1) = CFACE_corank(F2)+1 and THIS[`&<=`](F1, F2)
  fi
end;

#`face/&>>` := proc(F1, F2)
#  `face/&<<`(F2, F1)
#end;

succhspacenos := proc(C::{CONE, POLYHEDRON}, F::{CFACE, PFACE})
local hn, sat, Fr, i;
  hn := Hspacenos(F);
  sat := Incidentfacets(C);
  Fr := [ seq(hn intersect sat[i], i = {$1..nops(Rays(C))} minus Raynos(F)) ];
  [ seq(Fr[i], i = maximalsets(Fr)) ]
end;

CFACE[_hspacenos2face] := proc(C::{CONE, POLYHEDRON}, hn::set)
# optional third argument: corank of the new face
local sat2, i;
  if hn = {}
    then
      THIS[NEW]({$1..nops(Rays(C))}, hn, C, 0)
    else
      sat2 := Incidentrays(C);
      THIS[NEW](`intersect`(seq(sat2[i], i = hn)), hn, C, args[3..-1])
  fi
end;

CFACE[_raynos2face] := proc(C, rn)
  THIS['_dual'](THIS['_hspacenos2face'](Dual(C), rn))
end;

CFACE[pred] := proc(F)
local C, rnl;
  C := Domain(F);
  rnl := succhspacenos(Dual(C), THIS['_dual'](F));
  if nargs > 1
    then ERRORnargs
  elif THIS = 'PFACE' and not Isbounded(C)
    then rnl := select(raynos_isaffine, rnl, NRays(C))
  fi;
  map(THIS['_dual'],
      map2(THIS['_hspacenos2face'], Dual(C), rnl, CFACE['rank'](F)-1))
end;

CFACE[succ] := proc(F)
local C;
  C := Domain(F);
  if nargs > 2
    then ERRORnargs
  elif type(C, POLYHEDRON) and Raynos(F) = {}
    then POLYHEDRON['_edges'](C)
    else map2(THIS['_hspacenos2face'], C, succhspacenos(C, F))
  fi
end;

CFACE[maximum] := proc(F1)
# optional further args: F2, ..., Fn::face
local C, Fl, F;
  C := Domain(F1);
  Fl := [ args ];
  if not type(Fl, list(THIS))
    then ERRORillegalcomb
  elif ormap(proc(x) Domain(x) <> C end, Fl)
    then ERRORsamedomain
    else THIS['_hspacenos2face'](C, `intersect`(seq(Hspacenos(F), F = Fl)))
  fi
end;

CFACE[minimum] := proc(f1)
local al, f;
  al := [args];
  if not type(al, list(THIS)) then ERRORillegalcomb fi;
  f := traperror(THIS['maximum'](op(map(THIS['_dual'], al))));
  if f = lasterror
    then ERROR(lasterror)
  elif THIS = 'CFACE'
       or raynos_isaffine(Hspacenos(f), NRays(Domain(f1)))
    then THIS['_dual'](f)
    else POLYHEDRON['minimal'](Domain(f1))
  fi
end;

CFACE[_faceseq] := proc(C, F1, F2)
local rn1, rn2, hn1, L, sat, i, F, FL;
  rn1 := Raynos(F1);
  rn2 := Raynos(F2);
  hn1 := Hspacenos(F1);
  sat := Incidentfacets(C);
  FL := NULL;
  while rn1 <> rn2 do
    if rn1 = {}
      then
        # HACK: we use the fact that the last rayno corresponds to a vertex
        rn1 := {nops(Rays(C))};
        hn1 := sat[-1];
        F := THIS[NEW](rn1, hn1, C)
      else
        L := [seq(sat[i] intersect hn1, i = rn2 minus rn1)];
        hn1 := L[findmax(nops, L)];
        F := THIS['_hspacenos2face'](C, hn1);
        rn1 := Raynos(F)
    fi;
    FL := FL, F
  od;
  FL
end;

#  CFACE[facechain] := proc(F1, F2)
#  local Fmin, Fmax, L, i;
#    if nargs > 2
#      then ERRORnargs
#    elif not type(F2, THIS)
#      then ERRORillegalcomb
#    elif THIS[`&<=`](F1, F2)
#      then [THIS['_faceseq'](Domain(F1), F1, F2)]
#    elif THIS[`&<=`](F2, F1)
#      then
#        L := [THIS['_faceseq'](Domain(F1), F2, F1)];
#        [ seq(L[-i], i = 2..nops(L)), F2 ]
#      else ERRORfacecontain
#    fi
#  end;

CFACE[DOMTYPE] := proc(F)
# this procedure is not optimal!
local C, r, sat, i, T, C2;
  if nargs > 1 then ERRORnargs fi;
  C := Domain(F);
  r := Rays(C);
  sat := Incidentfacets(C);
# we assume that positive integers in sets are ordered! WHERE???
  C2 := reduce(NEWCONE(Ambientdim(C), Lines(C),
	               [seq(r[i], i = Raynos(F))],
                       [seq(sat[i], i = Raynos(F))],
                       Hplanes(C), Hspaces(C), []));
  if THIS = 'PFACE' then C2 := NEWPOLYHEDRON(C2) fi;
  T := OBJ_TYPE(C);
  if T = T[BASE]
    then C2
    else T[NEW](C2, FANCONE['domain'](C))
  fi
end;
