# VERSION := cat("pre1.1-", ssystem("date +%Y%m%d")[2][1..-2]);

$define maple7	substring(kernelopts(version), 7) = `7`

# correct Maple bugs
$define abs_igcd	abs
  # igcd may return negative values in Maple 7, 8

$include "errors.mt"
$include "macros.mt"
$include "types.mt"

# macros for methods

macro(THIS = op(0, procname));
macro(METHOD = op(procname));
macro(BASE = '_base');
macro(EL = '_el');
macro(NEW = '_new');
macro(DOM = '_dom');
macro(DOMTYPE = '_2domtype');
macro(POSDOM = '_dom'); # same as DOM
macro(SHIFT = '_shift');

macro(hasnotBASE = `type/!BASE`);
hasnotBASE := proc(x, T) op(0, x) <> OBJ or op(1, x)[BASE] <> T[BASE] end;

`print/_OBJ` := proc(T) T['_print'](args[2..-1]) end;

convex := proc(x)
option package;
global CONVEX;
local m, fcn;
  m := op(1, procname);
  if assigned(CONVEX[m])
    then fcn := CONVEX[m]
    else fcn := op(1, x)[m]
  fi;
  if type(fcn, procedure)
    then
      try
        fcn(args);
        catch "invalid input" : m := lastexception[7];
                                if op(0, m) = OBJ
                                  then error lastexception[2..6],
                                             `print/_OBJ`(op(m))
                                  else error
                                fi;
#         catch "" : error
      end try
    else ERROR("method not defined")
  fi
end;

convex(_InitFile) := proc()
$ifndef VERBOSE
  if not interface(quiet)
    then
$endif
      printf("Convex version " VERSION ", Copyright (C) 1999-" YEAR " Matthias Franz\n"
        "This package is distributed under the GNU General Public License\n"
	"See http://www.math.uwo.ca/~mfranz/convex/ for more information\n"
#	"This version is still UNDER CONSTRUCTION!\n"
        )
$ifndef VERBOSE
  fi
$endif
end;

#convex(license) := proc(fn)
#local S, L;
#  S := "";
#  while true do
#    L := readline(fn);
#    if L = 0 then break fi;
#    S := cat(S, L, "\n")
#  od;
#  convert(S, symbol)
#end("LICENSE");

CONVEX := table();
CONE := table(); POLYHEDRON := table();
CFACE := table(); PFACE := table();
FAN := table(); FANCONE := table();
PCOMPLEX := table(); CELL := table();
MODZ := table();

SWITCH := proc(x)
global CONVEX;
local fcn;
  if assigned(CONVEX[procname])
    then fcn := CONVEX[procname]
    else fcn := op(1, x)[procname]
  fi;
  if type(fcn, procedure)
    then fcn(args)
    else 'procname'(args)
  fi
end;

SWITCH2 := proc(x)
global CONVEX;
local fcn, T;
  T := op(0, x);
  if T = OBJ
    then fcn := op(1, x)[op(procname)]
    else fcn := CONVEX[op(procname), T]
  fi;
  if type(fcn, procedure)
    then fcn(args)
    else ERROR("method not defined")
  fi
end;

SWITCH2FAN := proc(x)
  THIS[POSDOM][METHOD](THIS[POSDOM]['_create']([x]), args[2..-1])
end;

COPYNEWENTRIES := proc(A::table, B::table)
local i;
  for i in [indices(A)] do
    if not assigned(B[op(i)])
      then
        if type(eval(A[op(i)]), table)
          then B[op(i)] := A[op(i)]
          else B[op(i)] := eval(A[op(i)])
        fi
    fi
  od
end;

# sourcing files

$include "std.mt"
$include "basics.mt"

$include "coeffs.mt"
$include "modz.mt"

$include "motzkin.mt"

$include "cone_polyhedron.mt"
$include "polyhedron.mt"
$include "cone.mt"

$include "cface_pface.mt"
$include "pface.mt"
$include "cface.mt"

$include "fan_pcomplex.mt"
$include "pcomplex.mt"
$include "fan.mt"

$include "fancone_cell.mt"
$include "cell.mt"
$include "fancone.mt"

$include "examples.mt"
$include "toric.mt"

# if lasterror <> 'lasterror' then ERROR("compilation stopped") fi;

`&=` := eval(SWITCH);
`&<=` := eval(SWITCH);
`&<` := eval(SWITCH);
`&x` := eval(SWITCH);
`&<<` := eval(SWITCH);

`&<>` := () -> not `&=`(args);
`&>=` := (f1, f2) -> `&<=`(f2, f1, args[3..-1]);
`&>` := (f1, f2) -> `&<`(f2, f1, args[3..-1]);
`&>>` := (f1, f2) -> `&<<`(f2, f1, args[3..-1]);

CONVEX[contains] := eval(SWITCH2);

CONVEX[iscontained] := proc(arg1, arg2)
  CONVEX['contains'](arg2, arg1)
end;

`convert/CONE` := eval(SWITCH);
`convert/POLYHEDRON` := eval(SWITCH);
`convert/FAN` := eval(SWITCH);
`convert/PCOMPLEX` := eval(SWITCH);
`convert/CFACE` := eval(SWITCH);
`convert/PFACE` := eval(SWITCH);
`convert/affine` := eval(SWITCH);

dummy := proc() convex[procname](args) end;
convex(_PackageTable) :=
  table([seq(op(i) = eval(dummy),
             i = select(x -> nops(x) = 1
                        and substring(x[1], 1) <> '_'
                        and substring(x[1], 1) <> '`&`'
                        and searchtext("/", x[1]) = 0,
                        map(indices,
                        {CONVEX,
			 MODZ,
                         CONE, POLYHEDRON,
                         CFACE, PFACE,
                         FAN, FANCONE})))]);
dummy := 'dummy';

SWITCH := 'SWITCH';
SWITCH2 := 'SWITCH2';
SWITCH2FAN := 'SWITCH2FAN';
COPYNEWENTRIES := 'COPYNEWENTRIES';

protect(convex, CONVEX, MODZ,
  CONE, POLYHEDRON, CFACE, PFACE, FAN, FANCONE, PCOMPLEX, CELL, line, affray,
  `&=`, `&<>`, `&<=`, `&<`, `&<<`, `&x`, `&>=`, `&>`, `&>>`);

#
# saving the module to a repository
#

march('create', convexrep, 128);
savelibname := currentdir();

proc() lprint(args); savelib(args) end
 (op({anames()} minus
     {`index/fill`, `index/FillInitVals`, march,
      polar, protect, readline, currentdir, 'savelibname', Vector, VERSION}));

map(march, ['gc', 'reindex', 'pack'], convexrep);
march('setattribute', convexrep, mode="READONLY");

stop


# saving as .m file

proc() lprint(args); save args, "convex.m" end
 (op({anames()} minus
     {`index/fill`, `index/FillInitVals`, march,
      polar, protect, readline, 'savelibname', Vector, VERSION}));

# march('create', "convex.lib", 1);
# march('add', "convex.lib", "convex.m", 'convex');

stop
