#
# type FAN
#

`type/FAN` := proc(x)
  op(0, x) = OBJ and op(1, x) = 'FAN'
end;

`type/FAN0` := proc(x)
  `type/FAN`(x) and FAN_lines(x) = []
end;

FAN[EL] := 'FANCONE';

FAN[SHIFT] := 0;

FAN[_print] := proc(d::nonnegint, l::list, MC)
local n, T;
  T := &?(type(MC, array), MC, table(op(2, MC)));
  # we can't use MC directly, since its type is not `array', but `ARRAY',
  # which must be some sort of display version
  # This doesn't apply if called from the global method handler
  # in case of errors
  'FAN'(d, nops(l), [seq(nops(T[n]), n = 1..d)])
end;

FAN[lines] := proc(F)
  if nargs > 1
    then ERRORnargs
    else FAN_lines(F)
  fi
end;

FAN[rays] := proc(F)
  if nargs > 1
    then ERRORnargs
    else `union`(op(map(Rays_set, FAN_maximal_list(F))))
  fi
end;

FAN[hplanes] := proc(F)
local MC, d, C, rs;
  if nargs > 1 then ERRORnargs fi;

  d := FAN_ambientdim(F);
  MC := FAN_maximal_list(F);
  rs := `union`(op(map(Rays_set, MC))); # FAN['rays'](F)
  if nops(MC) = 1
    then Hplanes(MC[1])
  elif FAN_lines(F) <> FAIL
    then Hplanes(Hull(d, [], [op(FAN_lines(F)), op(rs)], []))
    else # possible if F is actually a PCOMPLEX
      Hplanes(Hull(d, [], [seq(op(Lines(C)), C = MC), op(rs)], []))
  fi
end;

FAN[isregular] := eval(FAN[issimplicial]);

zerofan := proc(d::nonnegint)
option remember;
  if nargs > 1
    then ERRORnargs
    else FAN['_create']([zerocone(d)], false)
  fi
end;

`face/convert/fancone` := proc(F::CFACE)
# UPDATE!
  FANCONE[NEW](`face/convert/cone`(F),`fancone/domain`(`face/domain`(F)))
end;

FAN[minimal] := proc(F)
# not very efficient
  if nargs > 1
    then ERRORnargs
    else [FANCONE[NEW](Hull(FAN_ambientdim(F), [], FAN_lines(F), []), F)]
      # better with 'lineality' ? (not yet defined for POLYHEDRON)
  fi
end;

FAN[`convert/PCOMPLEX`] := proc(F)
local L;
  try
    L := map(CONE['`convert/POLYHEDRON`'], FAN_maximal_list(F), args[2..-1]);
  catch "" : error lastexception[2], procname, lastexception[4..-1]
  end try;
  PCOMPLEX['_create'](L, false)
end;

FAN[`convert/affine`] := proc(F)
local L;
  try
    L := map(affinecone, FAN_maximal_list(F), args[2..-1]);
  catch "" : error lastexception[2], procname, lastexception[4..-1]
  end try;
  PCOMPLEX['_create'](L, false)
end;

`convex/facefan/facet2cone` := proc(F::CFACE, n, ll, eq)
# F must be a facet
local C, dh;
  dh := dehomog(CFACE['hspaces'](F)[1]);
  if dh[2] <> 0
    then
      C := CFACE[DOMTYPE](F);
      NEWCONE(n, ll, # just to make sure
        map(x -> reducevec(dehomog(x)[1]), Rays(C)),
        Incidentfacets(C), eq,
# All hspaces of the big cone C have last component >= 0, since C contains the
# origin. In the next line, x is positively scaled and y = h negatively. This
# is ok, because h vanishes on all rays of F.
        map(proc(x) combinevecs(dehomog(x), dh) end, Hspaces(C)),
        Incidentrays(C))
    # else RETURN(NULL)
  fi
end;

facefan := proc(P::POLYHEDRON0)
  if nargs > 1
    then ERRORnargs
    else normalfan(Dual(P))
  fi
end;

normalfan := proc(P::POLYHEDRON1)
local C, n, d, ll, eq;
  if nargs > 1 then ERRORnargs fi;

  C := Dual(POLYHEDRON['`convert/CONE`'](P));
  # conversion necessary, since `face/convert/cone` tests type
  n := POLYHEDRON['ambientdim'](P);
  d := POLYHEDRON['dim'](C);
  ll := map(x -> dehomog(x)[1], Lines(C));
  # reducevec not necessary, since X0-coordinate = 0
  # and automatically gausselim'ed
  # CORRECT???
  eq := gausselim(map(x -> dehomog(x)[1], Hplanes(C)));
  FAN[NEW](n, ll, array(0..n, [ []$d, map(`convex/facefan/facet2cone`,
					  CONE['facets'](C), n, ll, eq),
			[]$n-d ]))
end;

`FAN/stellarsubdiv/subdivide` := proc(C::CONE, d, lr, RS::set)
local F, ll;
  if not (RS subset Rays_set(C)) or (nops(RS) = 1 and CONE['issimplicial'](C))
    then RETURN(C)
  fi;
  ll := Lines(C);
  seq(`&?`(RS subset CFACE_rays_set(F),
	   NULL,
           subsop(CONE_OP_lines = ll, # just to make sure
		  Hull(d, [CFACE[DOMTYPE](F)], [], lr))),
      F = CONE['facets'](C))
end;

FAN[stellarsubdiv] := proc(F0)
local rl, r, d, S, F;
  if not FAN['ispointed'](F0) then ERROR("sorry, fan must be pointed") fi;

  rl := [args[2..-1]];
  if not type(rl, list(ray))
    then ERRORtype
  fi;
  F := F0;
  d := FAN_ambientdim(F);
  for r in map(reduceqvec, rl) do
    if nops(r) <> d then ERRORnotsamespace fi;
    S := FAN['support'](F, r);
    if S = FAIL then next fi;
    S := Rays_set(S);
    if S = {}
      then ERROR("ray is contained in the minimal cone")
      else
	# WRONG!!! if fan is not pointed
	# ray must be made perpendicular to lineality space !
	F := subsop(FAN_OP_maximal_array
		      = map2(map, `FAN/stellarsubdiv/subdivide`,
                             FAN_maximal_array(F), d, [r], S),
		    F)
    fi
  od;
  F
end;

`FAN/regularsubdiv/subdivide` := proc(C, d, lr, RS)
global `FAN/regularsubdiv/rMC`;
local F, rCS, sCS, C2, n;
  if not RS subset Rays_set(C) then RETURN(C) fi;
  rCS := NULL;
  sCS := NULL;
  for F in CONE['facets'](C) do
    if RS subset CFACE_rays_set(F) then next fi;
    C2 := Hull(d, [CFACE[DOMTYPE](F)], [], lr);
    if CONE['isregular'](C2)
      then rCS := rCS, C2
      else sCS := sCS, C2
    fi
  od;
  n := Dim(C);
  `FAN/regularsubdiv/rMC`[n] := [op(`FAN/regularsubdiv/rMC`[n]), rCS];
  sCS
end;

FAN[regularsubdiv] := proc(F::FAN0)
global `FAN/regularsubdiv/rMC`;
local MC, sMC, n, d, C, B, U, i, j, r, rl, rs, F2;
  if nargs > 1 then ERRORnargs fi;
#  if not FAN['ispointed'](F) then ERROR("sorry, fan must be pointed") fi;

  MC := FAN_maximal_array(F);
  d := FAN_ambientdim(F);
  `FAN/regularsubdiv/rMC` := array(0..d, [[]$d+1]);
  sMC := array(0..d, [[]$d+1]);
  for n from 0 to d do
    for C in MC[n] do
      if CONE['isregular'](C)
        then `FAN/regularsubdiv/rMC`[n] := [op(`FAN/regularsubdiv/rMC`[n]), C]
        else sMC[n] := [op(sMC[n]), C]
      fi
    od
  od;
  for n from 2 to d do
    while sMC[n] <> [] do
      userinfo(4, FAN,
               nops(sMC[n]), '`singular cone(s) left in dimension`', n);
      C := sMC[n][1];
      # find new ray
      rl := Rays(C);
      if nops(rl) <> n
        then
#          ERROR("sorry, fan should be simplicial")
          userinfo(2, FAN, '`restarting with simplicial subdivision`');
          RETURN(FAN['regularsubdiv'](FAN['simplicialsubdiv'](F)))
      fi;

#      B := hermite2(transpose(rl), true, U);
#      for i to n while B[i, i] = 1 do od;
#      rs := rl[i];
#      for j to i-1 do
#        if B[j, i] <> 0 then U[j] := U[j]-U[i]; rs := rs, rl[j]; fi
#      od;
#      U := inverse(U);
#      r := [seq(U[j, i], j = 1..d)]; # this is the new ray
      B := hermite2inv(transpose(rl), true, U);
      # now U has a value
$ifdef MINT
  U := [];
$endif
      for i while B[i, i] = 1 do od;
      r := U[i]; # this will be the new ray
      rs := rl[i];
      for j to i-1 do
        if B[j, i] <> 0 then r := r+U[j]; rs := rs, rl[j]; fi
      od;

      rs := {rs}; # rays of supporting fancone

      if nops(rs) = n
        then # new ray is in the relative interior of the current cone
          sMC[n] := subsop(1 = `FAN/regularsubdiv/subdivide`(C, d, [r], rs),
                           sMC[n])
        else # we have to subdivide all cones
          # why does this not work?!
          #   map2(map, `FAN/regularsubdiv/subdivide`, sMC, d, [r], rs)
          for i from 2 to d do
            sMC[i] := map(`FAN/regularsubdiv/subdivide`, sMC[i], d, [r], rs)
          od
      fi
    od
  od;
  F2 := subsop(FAN_OP_maximal_array = eval(`FAN/regularsubdiv/rMC`), F);
  `FAN/regularsubdiv/rMC` := '`FAN/regularsubdiv/rMC`';
  F2
end;

#`FAN/delete` := proc(C1)
#local Cl, rs, r, F, d, C, dC, MC, i;
#  Cl := [args];
#  if not type(Cl, list(fancone)) then ERRORfancone fi;
#  F := `fancone/domain`(C1);
#  d := `FAN/ambientdim`(F);
#  rs := array(0..d);
#  for C in Cl do
#    if `fancone/domain`(C) <> F then ERRORsamedomain fi;
#    r := Rays_set(C);
#    if r = {} then ERROR("cannot remove minimal cone") fi;
#    dC := Dim(C);
#    rs[dC] := [op(rs[dC]), r]
#  od;
#  MC := FAN_maximal_array(F);
#  for i from d to 0 by -1 do
#  od;

#
# test for (quasi-)polytopal fan
#

FAN[isquasipolytopal] := proc(F, P::name)
local d, r, ind_C, ind_r, i, L, L0, L1, eq, ineq, C, n, dn, Fr;
  if nargs > 2 then ERRORnargs fi;
  userinfo(3, FAN, `trying to find strictly convex support function`);
  d := FAN_ambientdim(F);
  L := FAN_maximal_list(F);
  Fr := FAN['rays'](F);
  n := nops(L);
  dn := d*n;
  for i to n do
    ind_C[L[i]] := d*(i-1)
  od;
  eq := seq(seq(embed(dn, r, ind_C[C]), r = Hplanes(C)), C = L),
        seq(seq(embed(dn, r, 0, -r, d*i), i = 1..n-1), r = FAN_lines(F));
  ineq := NULL;
  for r in Fr do
    L1, L0 := selectremove(proc(C) member(r, Rays(C)) end, L);
    i := ind_C[L1[1]];
    ind_r[r] := i;
    eq   :=   eq, seq(embed(dn, r, i, -r, ind_C[C]), C = L1[2..-1]);
    ineq := ineq, seq(embed(dn, r, i, -r, ind_C[C]), C = L0)
  od;
  C := Intersection(dn, [], [eq], []);

  ineq := [ineq];
  L := Lines(C);
  for r in ineq do
    if andmap(proc(x) evalb(Dotprod(x, r) = 0) end, L) then RETURN(false) fi
      # this means that r vanishes on all support functions
  od;

  i := Codim(C);
  C := Intersection(dn, [C], [], ineq);
  eq := evalb(Codim(C) = i);
  if eq and nargs = 2
    then
      userinfo(3, FAN, `constructing polyhedron`);
      r := Relint(C);
      P := POLYHEDRON['_intersection'](d+1, [],
	     map(proc(v) homog(v, Dotprod(v, r[1..d])) end, FAN_lines(F)),
             map(proc(v) homog(v, Dotprod(v, r[ind_r[v]+1..ind_r[v]+d])) end,
                 Fr))
  fi;
  eq
end;

FAN[ispolytopal] := proc(F, P::name)
  if nargs > 2 then ERRORnargs fi;
  userinfo(3, FAN, `testing completeness`);
  FAN['iscomplete'](F) and FAN['isquasipolytopal'](args,
    userinfo(3, FAN, `testing quasi-polytopeness`))
end;

FAN[regularpart] := proc(F::FAN0)
local L;
  if nargs > 1 then ERRORnargs fi;
  L := NULL;
  FAN['traverse'](F,
		  proc(f)
		    if CFACE['isregular'](f) # not very efficient!
		      then L := L, f; false
		      else true
		    fi
		  end);
  FAN['_create'](map(CFACE[DOMTYPE], [L]), false)
end;

#
# h-vector
#

FAN[hvector] := proc(F)
local f, n, i, j;
  n := FAN_ambientdim(F);
  f := FAN['fvector'](F);
  Array(0..n, [seq(`+`(seq((-1)^(i-j)*binomial(n-j, i-j)*f[j], j = 0..i)),
                   i = 0..n)])
end;

#
# generalised h-vector
#

FAN[genhvector] := proc(F::FAN0)
# Stanley's generalized h-vector
local n, p, x, i;
  if nargs <> 1 then ERRORnargs fi;
  # x is intentionally undefined
$ifdef MINT
  x := 0;
$endif
  p := FAN['genhpolynomial'](F, x);
  n := FAN_ambientdim(F);
  Array(0..n, [seq(coeff(p, x, i), i = 0..n)])
end;

FAN[genhpolynomial] := proc(F::FAN0, q::algebraic)
# Stanley's generalized h-polynomial
local MC, f_facets, g, h, n, IP, x, p;

  if nargs > 2 then ERRORnargs fi;

  n := FAN_ambientdim(F);

  f_facets := THIS[EL][EL]['pred'];
    # necessary?

  h := proc(rs, rs2, n2)
    option remember;
      IP[rs2] := IP[rs2]+expand((x-1)^(n2-CFACE['dim'](_Env_f))*g(rs));
      for _Env_f in f_facets(_Env_f) do
        h(CFACE_rays_set(_Env_f), rs2, n2)
      od
    end;

  g := proc(rs)
    option remember;
    local n1, i, p;
      n1 := CFACE['dim'](_Env_f);
      if n1 = nops(rs) then RETURN(1) fi;

      n1 := n1-1;
      IP[rs] := 0;
      for _Env_f in f_facets(_Env_f) do
        h(CFACE_rays_set(_Env_f), rs, n1)
      od;

      p := expand((1-x)*IP[rs]);
      `+`(seq(coeff(p, x, i)*x^i, i = 0..n1/2))
    end;

  IP := table();
  IP[0] := 0;

  MC := map(THIS[EL]['maximal'], THIS['maximal'](F, 'list'));

  if nops(MC) = 1
    then
      _Env_f := MC[1];
      p := expand((x-1)^(n-CFACE['dim'](_Env_f))*g(CFACE_rays_set(_Env_f)))
    else
      for _Env_f in MC do
        h(CFACE_rays_set(_Env_f), 0, n)
      od;
      p := expand(x^n*subs(x = 1/x, IP[0]))
  fi;

  if nargs = 2
    then subs(x = q, p)
    else p
  fi
end;
