#
# common definitions for types FAN and PCOMPLEX
#

FAN[NEW] := proc()
  OBJ(THIS, args)
end;

FAN[ambientdim] := proc(F)
  if nargs > 1
    then ERRORnargs
    else FAN_ambientdim(F)-THIS[SHIFT]
  fi
end;

FAN[codim] := proc(F)
  if nargs > 1
    then ERRORnargs
    else nops(FAN['hplanes'](F))
  fi
end;

FAN[dim] := proc(F)
local i, MC;
  if nargs > 1 then ERRORnargs fi;
  MC := FAN_maximal_array(F);
  for i from FAN_ambientdim(F) by -1 do
    if MC[i] <> [] then RETURN(i-THIS[SHIFT]) fi
  od
end;

FAN_maximal_list := proc(F::{FAN, PCOMPLEX})
local d, i, MC;
  d := FAN_ambientdim(F);
  MC := FAN_maximal_array(F);
  [ seq(op(MC[d-i]), i = 0..d) ]
end;

FAN[maximal] := proc(F, T)
local MC, i, d;
  if nargs > 2
    then ERRORnargs
  elif nargs = 1 or T = 'list'
    then RETURN(map(THIS[EL][NEW], FAN_maximal_list(F), F))
  elif T <> 'array'
    then ERRORillegalcomb
  fi;
  MC := map2(map, THIS[EL][NEW], FAN_maximal_array(F), F);
  if THIS = 'FAN'
    then eval(MC)
    else
      d := Ambientdim(F);
      array(-1..d-1, [seq(MC[i], i = 0..d)])
  fi;
end;

FAN[ispointed] := proc(F)
  if nargs > 1
    then ERRORnargs
    else evalb(FAN_lines(F) = [])
  fi
end;

CONVEX[fan] := proc()
local Cl, T, F;
  Cl := [args];

  if METHOD = 'fan'
    then
      if type(Cl, list({CONE, FAN}))
        then T := FAN
        else ERRORtype
      fi
  elif type(Cl, list({POLYHEDRON, PCOMPLEX}))
    then T := PCOMPLEX
    else ERRORtype
  fi;

  try
    F := T['_create'](map(proc(x)
	                 if type(x, T) then op(T['maximal'](x)) else x fi
                       end, Cl),
                   true);
  catch "" : ERROR(lasterror)
  end try;
  F
end;

FAN['_create'] := proc(Cl1::list, compattest)
# compattest not needed if Cl1 has just one element
local d, l, C, Cl, MC, n, Cd, C2, notred, m_compat;

  if nops(Cl1) = 1
    then
      C := Cl1[1];
      d := Ambientdim(C);
      n := Dim(C);
      RETURN(THIS[NEW](d, Lines(C),
                       array(0..d,
                             [[]$n, [convert(C, THIS[EL][BASE])], []$d-n])))
  fi;

  m_compat := () -> true;
  Cl := sort(Cl1, (x, y) -> evalb(Codim(x) < Codim(y)));
  d := Ambientdim(Cl[1]);
  l := Lines(Cl[1]);
  MC := array(0..d, [ []$d+1 ]);
  for C in Cl do
    if Ambientdim(C) <> d then ERRORnotsamespace fi;
#    C := subsop(CONE_OP_lines = l, C);
    if Lines(C) <> l then l := FAIL fi;
    if compattest then m_compat := OBJ_TYPE(C)['arecompatible'] fi;
    Cd := Dim(C);
    notred := true;
    for n from d to Cd by -1 while notred do
      for C2 in MC[n] do
        if not m_compat(C, C2)
          then ERRORcompatible
        elif Rays_set(C) subset Rays_set(C2)
          then
            userinfo(2, THIS, '`redundant argument`');
            notred := false;
            break
        fi
      od
    od;
    if notred
      then MC[Cd] := [ op(MC[Cd]), C ]
    fi
  od;

  THIS[NEW](d, l, map2(map, convert, MC, THIS[EL][BASE]))
end;

# FAN['_purefan'] := proc(Cl::list, ll::list)
# local n, d;
#   n := Ambientdim(Cl[1]);
#   d := Codim(Cl[1]);
#   THIS[NEW](n, ll, array(0..n, [[]$n-d, Cl, []$d]))
# end;

FAN[support] := proc(F)
# what should the return type be if FAN[support] is called with a PCOMPLEX ?
# at present, it is FANCONE
local C, f;
  for C in FAN_maximal_list(F) do
    f := traperror(THIS[EL]['support'](C, args[2..-1]));
    if f = lasterror
      then ERROR(lasterror)
    elif f <> FAIL
      then RETURN(THIS[EL][NEW](THIS[EL][EL][DOMTYPE](f), F))
    fi
  od;
  FAIL
end;

FAN[contains] := proc(F, C, FC::name)
local Fl, Cl, Cr, C1, f, d, n, i, MC, cmp;
  if nargs > 3
    then ERRORnargs
  elif hasnotBASE(C, THIS[EL])
    then ERRORtype
  fi;

  n := Ambientdim(C);
  d := Dim(C);
  if n <> FAN_ambientdim(F)
    then ERRORnotsamespace
  elif THIS = 'PCOMPLEX' and d = 0
    then
      if nargs = 3 then FC := PCOMPLEX['minimal'](F)[1] fi;
      RETURN(true)
  fi;

  Fl := FAN_lines(F);
  Cl := Lines(C);
  Cr := Rays_set(C);

  if Fl = FAIL
    then cmp := proc(x) Lines(x) = Cl and Cr subset Rays_set(x) end
  elif Fl = Cl
    then cmp := proc(x) Cr subset Rays_set(x) end
    else RETURN(false)
  fi;

  MC := FAN_maximal_array(F);
  for i from n to Dim(C) by -1 do
    for C1 in select(cmp, MC[i]) do
      f := CONE['support'](C1, op(Cr));
      if f <> FAIL
        then
          if nargs = 3
            then FC := THIS[EL][NEW](THIS[EL][EL][DOMTYPE](f), F)
          fi;
          RETURN(evalb(Cr = CFACE_rays_set(f)))
      fi
    od
  od;

  false
end;

FAN[`&=`] := proc(F1, F2)
local ll1, cmp, i, d, MC1, MC2;
  d := FAN_ambientdim(F1);
  if nargs > 2
    then ERRORnargs
  elif not type(F2, THIS)
    then ERRORtype
  elif d <> FAN_ambientdim(F2)
    then RETURN(false)
  fi;

  ll1 := FAN_lines(F1);
  if ll1 <> FAN_lines(F2) then RETURN(false) fi;

  cmp := &?(ll1 = FAIL, x -> [Lines(x), Rays_set(x)], Rays_set);
  MC1 := FAN_maximal_array(F1);
  MC2 := FAN_maximal_array(F2);
  for i from 0 to d do
    if convert(map(cmp, MC1[i]), set) <> convert(map(cmp, MC2[i]), set)
      then RETURN(false)
    fi
  od;

  true
end;

FAN[`&<=`] := proc(F1, F2)
local n, i, C, MC;
  n := FAN_ambientdim(F1);

  if nargs > 2
    then ERRORnargs
  elif not type(F2, THIS)
    then ERRORtype
  elif n <> FAN_ambientdim(F2)
    then ERRORnotsamespace
    else
      MC := FAN_maximal_array(F1);
      for i from 0 to n do
        for C in MC[i] do
          if not THIS['contains'](F2, C) then RETURN(false) fi
        od
      od;
      true
  fi
end;

FAN[`&<`] := proc(F1, F2)
local MC1, MC2, i;
  if nargs > 2
    then ERRORnargs
  elif THIS[`&<=`](args)
    then
      MC1 := FAN_maximal_array(F1);
      MC2 := FAN_maximal_array(F2);
      for i to FAN_ambientdim(F1) do
        # we don't need to test dimension 0
        if nops(MC1[i]) <> nops(MC2[i]) then RETURN(true) fi
      od
  fi;
  false
end;

FAN[`&x`] := proc(F1)
local Fl, F, MC1, MC2, i, j, C1, C2, l1, l2, d, d1, d2;
  Fl := [args];
  if nargs = 0
    then
      if THIS = 'FAN'
	then RETURN(zerofan(0))
	else RETURN(PCOMPLEX['_create']([fullpolyhedron(0)]))
      fi
  elif not type(Fl, list(THIS))
    then ERRORillegalcomb
  elif nargs = 1
    then RETURN(F1)
  elif THIS = 'PCOMPLEX' and ormap(PCOMPLEX['isempty'], Fl)
    then RETURN(PCOMPLEX['_create'](
	   [emptypolyhedron(`+`(op(map(PCOMPLEX['ambientdim'], Fl))))]))
  fi;

  d1 := FAN_ambientdim(F1)-THIS[SHIFT];
  l1 := FAN_lines(F1);
  MC1 := FAN_maximal_array(F1);
  for F in Fl[2..-1] do
    d2 := FAN_ambientdim(F);
    d := d1+d2; # this is THIS[SHIFT] greater than the real value
    # we use X0 = -1
    l2 := FAN_lines(F);
    if l1 = FAIL or l2 = FAIL
      then l1 := FAIL
      else l1 := [op(map2(embed, d, l1, 0)), op(map2(embed, d, l2, d1))]
    fi;
    MC2 := FAN_maximal_array(F);
    MC1 := array(0..d, [seq([seq(
      seq(seq(THIS[EL]['`&x`'](C1, C2), C2 = MC2[i-j]),
					C1 = MC1[j+THIS[SHIFT]]),
      j = max(0, i-d2)..min(d1, i))], i = 0..d)]);
    d1 := d;
  od;
  THIS[NEW](d1, l1, eval(MC1))
end;

FAN[image] := proc(F, A)
local F2;
  F2 := traperror(THIS['_create'](map(THIS[EL][BASE]['image'],
                                   FAN_maximal_list(F),
                                   args[2..-1]),
                               not type(A, {rational, ray, real_infinity})
                                 and (type(A, mat) and inverse(A) = FAIL)));
    # The image of a fan is not necessarily a fan!
    # But if A is rational or a ray then the images are always compatible.
  if F2 = lasterror
    then ERROR(lasterror)
    else F2
  fi
end;

FAN[preimage] := proc(F)
local F2;
  F2 := traperror(THIS['_create'](map(THIS[EL][BASE]['preimage'],
                                   FAN_maximal_list(F),
                                   args[2..-1]),
                                false));
 if F2 = lasterror
    then ERROR(lasterror)
    else F2
  fi
end;

FAN[issimplicial] := proc(F)
  if nargs > 1
    then ERRORnargs
    else andmap(THIS[EL][METHOD], FAN_maximal_list(F))
  fi
end;

FAN[iscomplete] := proc(F)
local MC, C, f, r, rs;
  MC := FAN_maximal_list(F);
  if nargs > 1
    then ERRORnargs
  elif Hplanes(MC[-1]) <> []
    then RETURN(false)
  fi;
  rs := {};
  for C in MC do
    for f in THIS[EL]['facets'](C) do
      r := CFACE_rays_set(f);
      if member(r, rs)
        then rs := rs minus { r }
        else rs := rs union { r }
      fi;
    od;
  od;
  rs = {} or (THIS = 'PCOMPLEX' and rs = {{}})
end;

#
# simplicial subdivision
#

`FAN/simplicialsubdiv/insert` := proc(C, sMC)
local e, n;
  n := Dim(C);
  e := nops(Rays(C))-n;
  if e = 0
    then sMC[n] := [op(sMC[n]), C]; NULL
    else [C, e]
  fi
end;

FAN[`simplicialsubdiv/subdivide`] := proc(Ce, d, r, sMC)
local C, F, p;
  C := Ce[1];
  if not member(r, Rays(C), p) then RETURN(Ce) fi;
  # now p has a value
$ifdef MINT
  p := 0;
$endif
  seq(`&?`(member(p, Raynos(F)), NULL,
           `FAN/simplicialsubdiv/insert`(THIS[EL][`_hull`](
             d, [CFACE[DOMTYPE](F)], [], [r]), sMC)),
      F = CONE['facets'](C))
end;

FAN[simplicialsubdiv] := proc(F)
local MC, sMC, L, d, n, C, FL, f, f2, f3;
  if nargs > 1
    then ERRORnargs
  elif not FAN['ispointed'](F)
    then ERROR("argument must be pointed")
  fi;

  d := FAN_ambientdim(F);
  MC := FAN_maximal_array(F);
  sMC := array(0..d, [MC[0], MC[1], MC[2], []$d-2]);
  L := [seq(seq(`FAN/simplicialsubdiv/insert`(C, sMC), C = MC[n]), n = 3..d)];
  while L <> [] do
    L := sort(L, cmpop2);
    C := L[1, 1];
    # determine the no of the ray to insert
    FL := sort(Incidentrays(C), (x, y) -> evalb(nops(x) >= nops(y)));
    f3 := FL[1]; # this is the most non-simplicial facet
    # we try to eliminate as many non-simplicial facets as possible
    for f in FL[2..-1] while f3 <> {} do
      f2 := f3;
      f3 := f3 intersect f
    od;
    # we insert the ray corresponding to op(1, f2)
    L := map(THIS[`simplicialsubdiv/subdivide`], L, d, Rays(C)[op(1, f2)], sMC)
  od;
  subsop(FAN_OP_maximal_array = eval(sMC), F);
end;

#
# traversal
#

FAN[traverse] := proc(F, g::procedure)
  if nargs > 2
   then ERRORnargs
   else THIS['traverse2'](F, g, proc() end)
  fi
end;

FAN[traverse2] := proc(F, f1::procedure, f2::procedure)
# args of f1: cone::{CFACE, PFACE}, raysset::set(ray)
# args of f2: facet::{CFACE, PFACE}, cone::{CFACE, PFACE},
#		raysset_facet::set(ray), raysset_cone::set(ray)
local g1, g2, # f_dim,
  f_facets, f_traverse;

  if nargs = 2
    then g1 := proc() option remember; true end; g2 := f1
  elif nargs = 3
    then g1 := f1; g2 := f2
    else ERRORnargs
  fi;

  # f_dim := THIS[EL][EL]['dim'];
  f_facets := THIS[EL][EL]['pred'];

  f_traverse := proc(rs)
    option remember;
    local F0, rs1;
      if g1(_Env_f, rs)
        then
          F0 := _Env_f;
          for _Env_f in f_facets(F0) do
	    rs1 := CFACE_rays_set(_Env_f);
            g2(_Env_f, F0, rs1, rs);
            procname(rs1)
          od
      fi
    end;

  try
    for _Env_f in map(THIS[EL]['maximal'], THIS['maximal'](F, 'list')) do
      f_traverse(CFACE_rays_set(_Env_f))
    od;
  catch "cannot evaluate boolean", "invalid boolean expression":
    if lastexception[1] = f_traverse
      then error "cannot evaluate return value of selection function to boolean"
      else error cat("error in selection function: ", lastexception[2]),
	     lastexception[3..-1]
    fi
  end try;

  map(op, {indices(procedure_remembertable(f_traverse))})
end;

FAN[skeleton] := proc(F, n::integer)
local L, f_dim;
  if nargs > 2
    then ERRORnargs
  elif n >= THIS['ambientdim'](F)
    then RETURN(F)
  fi;

  L := NULL;
  f_dim := THIS[EL][EL]['dim'];
  THIS['traverse'](F,
		   proc(f)
                     if f_dim(f) > n
                       then true
		       else L := L, f; false
                     fi
                   end);
  if L = NULL
    then ERROR("nothing selected")
    else THIS['_create'](map(THIS[EL][EL][DOMTYPE], [L]), false)
           # not very efficient!
  fi
end;

FAN[fvector] := proc(F)
local A, f_dim;
  if nargs > 1 then ERRORnargs fi;

  A := Array(-THIS[SHIFT]..THIS['ambientdim'](F));
  f_dim := THIS[EL][EL]['dim'];
  THIS['traverse'](F,
		   proc(f) local d; d := f_dim(f); A[d] := A[d]+1; true end);
  A
end;

`FAN/homology/getbasis` := proc(rs::set)
option remember;
  op(gausselim(convert(rs, list)))
end;

FAN[homology] := proc(F, F0)
local na, COEFF, A, OR, d, f_dim, getbasis, stop_rs;
  na, COEFF := parsemod(args);
  d := THIS['ambientdim'](F);
  if na = 1
    then
      stop_rs := &?(THIS = 'FAN', {}, {{}})
  elif na = 2
    then
      if not type(F0, THIS)
	then ERRORillegalcomb
      elif THIS['ambientdim'](F0) <> d
	then ERRORnotsamespace
      fi;
      stop_rs := convert(map(Rays_set, FAN_maximal_list(F0)), set)
    else
      ERRORnargs
  fi;

  userinfo(3, THIS, `determining incidences`);
  OR := table(sparse);
  A := Array(0..d, [{}$d+1]);
  f_dim := THIS[EL][EL]['dim'];
  getbasis := proc(rs::set)
              option remember;
		op(gausselim(convert(rs, list)))
	      end;

  if not stop_rs subset THIS['traverse2'](F,
    proc(f, rs)
      local d;
      if ormap(proc(x) rs subset x end, stop_rs)
	then
          false
        else
	  d := f_dim(f);
          A[d] := A[d] union {rs};
          true
      fi
    end,
    proc(f0, f1, rs0, rs1)
      # better: use different function for simplicial fans/pcomplexes
      # (It does not matter whether they are pointed or not.)
$ifdef MINT
  f0 = f1;
$endif
      OR[rs0, rs1] := sign(det(matmatmul([getbasis(rs1)],
                                         [getbasis(rs0),
                                          op(1, rs1 minus rs0)])))
    end)
  #if not stop_rs subset (result of traverse2)
    then ERRORcompatible
  fi;

  userinfo(3, THIS, `computing homology`);
  COEFF['_homology'](0, d, map(nops, A),
		     proc(k)
		     local i, j;
                       [seq([seq(OR[j, i], j = A[k-1])], i = A[k])]
	             end)
end;

# flag f-vector/h-vector

FAN[flagf] := proc(F, S::set(integer))
local f_dim, f_facets, f_traverse, L, m, flags;

  if nargs > 2
    then ERRORnargs
  elif S = {}
    then RETURN(1)
  fi;

  L := sort(convert(S, list), `>`);
  m := nops(L);

  f_dim := THIS[EL][EL]['dim'];
  f_facets := THIS[EL][EL]['pred'];

  f_traverse := proc(rs)
    option remember;
    local as, F0;
      if f_dim(_Env_f) <> L[nargs]
        then as := args[2..-1]
      elif nargs = m
        then flags := flags+1; RETURN()
        else as := args
      fi;
      F0 := _Env_f;
      for _Env_f in f_facets(F0) do
        procname(CFACE_rays_set(_Env_f), as)
      od
    end;

  flags := 0;

  for _Env_f in map(THIS[EL]['maximal'], THIS['maximal'](F, 'list')) do
    if f_dim(_Env_f) >= L[1]
      then
	f_traverse(CFACE_rays_set(_Env_f))
    fi
  od;

  flags
end;

FAN[flagh] := proc(F, S::set(integer))
local T, s, h;
  if nargs > 2 then ERRORnargs fi;
  h := 0;
  s := nops(S);
  for T in combinat['powerset'](S) do
    h := h+(-1)^(s-nops(T))*THIS['flagf'](F, T)
  od;
  h
end;

# FAN[flaghvector] := proc(F)
# # seems to be palindromic (for polytopal fans), but not used!
# local v, s, S, T, ff, n;
# 
#   ff := proc(T)
#     option remember;
#       FAN['flagf'](F, T)
#     end;
# 
#   n := FAN_ambientdim(F);
#   v := Array(0..n);
#   for s from 0 to n do
#     for S in combinat['choose'](n, s) do
#       for T in combinat['powerset'](S) do
#         v[s] := v[s]+(-1)^(s-nops(T))*ff(T)
#       od
#     od;
#     v[n-s] := v[s]
#   od;
#   v
# end;
