#
# type FANCONE
#

FANCONE[BASE] := 'CONE';
#FANCONE[DOM]  := 'FAN';

`type/FANCONE` := proc(x)
  op(0, x) = OBJ and op(1, x) = 'FANCONE'
end;

`type/CONE` := proc(x)
  op(0, x) = OBJ and member(op(1, x), {'CONE', 'FANCONE'})
end;

#FANCONE[NEW] := proc(C::CONE, F::FAN)
FANCONE[NEW] := proc(C::CONE, F)
# the "0" is a dummy entry, used for type POLYHEDRON
#  OBJ(THIS, op(2..CONE_NOPS, C), 0, F)
  OBJ(THIS, op(2..CONE_NOPS, C), 0, table([0 = F]))
end;

FANCONE[`convert/POLYHEDRON`] := proc(C)
local s1, s2;
$ifdef MINT
  s1 := 0; s2 := 0;
$endif
  if Ambientdim(C) = 0
    then ERRORdim0
    else CELL[NEW](CONE['`convert/POLYHEDRON`'](args),
                   subs([s1 = FAN['`convert/PCOMPLEX`'],
                         s2 = FANCONE['domain']],
                        s1(s2(C))))
  fi
end;

FANCONE[`convert/affine`] := proc(C)
local s1, s2;
$ifdef MINT
  s1 := 0; s2 := 0;
$endif
  CELL[NEW](affinecone(args),
            subs([s1 = FAN[`convert/affine`], s2 = FANCONE['domain']],
                 s1(s2(C), args[2..-1])))
end;

FANCONE[transversalfan] := proc(C, A::name)
local F, Fd, MC, r, eq, d, Cd, qMC, qFd;
  F := FANCONE['domain'](C);
  Fd := Ambientdim(C);
  Cd := Dim(C);
  if nargs > 2
    then ERRORnargs
  elif Cd = 0
    then
      if nargs = 2 then A := basiclists(Fd) fi;
      RETURN(F)
  fi;
  Cd := Dim(C);
  qFd := Fd-Cd;
  MC := FAN_maximal_array(F);
  Cd := Dim(C);
  r := Rays_set(C);
#  # compute the dual of a lattice complement of linearhull(C)
#  ihermite(transpose([op(Lines(C)), op(r)]), eq);
#  eq := convert(eq, listlist)[Cd+1..-1];
  eq := latticebasis(Hplanes(C));
  qMC := array(0..qFd, [seq(map(CONE['image'],
                                select(proc(x) r subset Rays_set(x) end, MC[d]),
                                eq),
                            d = Cd..Ambientdim(C))]);
  if nargs = 2 then A := eq fi;
  FAN[NEW](qFd, [], eval(qMC))
end;

#
# copy
#

COPYNEWENTRIES(CONE, FANCONE);
