#
# macro definitions
#

# operands of built-in types

$define vector_OP_nrows		[2, 2]
macro(vector_OP_from = [2, 1]);
macro(vector_OP_to   = vector_OP_nrows);
$define matrix_nrows(x)		op([2, 1, 2], eval(x))
$define matrix_ncols(x)		op([2, 2, 2], eval(x))

$define Vector_OP_nrows		1
$define Matrix_nrows(x)		op([1, 1], x)
$define Matrix_ncols(x)		op([1, 2], x)

macro(mat_nrows = `mat/nrows`);
mat_nrows := proc(A)
  if type(A, list)
    then nops(A)
  elif type(A, matrix)
    then matrix_nrows(A)
    else Matrix_nrows(A)
  fi
end;

macro(mat_ncols = `mat/ncols`);
mat_ncols := proc(A)
  if type(A, list)
    then nops(A[1])
  elif type(A, matrix)
    then matrix_ncols(A)
    else Matrix_ncols(A)
  fi
end;

# functions from other packages

# functions from this package

$define linrank(A)	nops(gausselim(A))
macro(det = CONVEX['_det']);
macro(cmpop2 = ((x, y) -> evalb(x[2] >= y[2])));
macro(basiclists = CONVEX['_idmat']);
macro(Dotprod = `convex/dotprod`);
macro(Dotprodwith = `convex/dotprodwith`);
macro(transpose = CONVEX['_transpose']);
macro(inverse = CONVEX['_inverse']);
macro(matvecmul = CONVEX['_matvecmul']);
macro(matmatmul = CONVEX['_matmatmul']);
macro(reducevec = `convex/reducevec`);
macro(reduceqvec = `convex/reduceqvec`);
macro(combinevecs = `convex/combinevecs`);
macro(gausselim = CONVEX['_gausselim']);
macro(gausselim2 = CONVEX['_gausselim2']);
macro(selectbasis = CONVEX['_selectbasis']);
macro(hermite1 = CONVEX['_hermite1']);
macro(hermite2 = CONVEX['_hermite2']);
macro(hermite2inv = CONVEX['_hermite2inv']);
macro(hermite3 = CONVEX['_hermite3']);
macro(latticebasis = CONVEX['_latticebasis']);
macro(maximalsets = `convex/maximalsets`);
macro(embed = `convex/embed`);
macro(NEWCONE = CONE['_new']);
macro(Dual = CONE['_dual']);
#macro(dual_face = CFACE['_dual']);
macro(Rays_set = `cone/_rays_set`);
macro(CFACE_rays = CFACE['rays']);
macro(NEWFACE = CFACE['_new']);
macro(raynos_isaffine = `convex/raynos/isaffine`);
macro(motzkin = `convex/motzkin`);
macro(transposesat = `convex/transposesat`);
macro(reduce = `convex/reduce`);
macro(Intersection = CONE['_intersection']);
macro(intersection = CONVEX['intersection']);
macro(Hull = CONE['_hull']);
macro(hull = CONVEX['poshull']);
macro(Image = CONE['image']);
macro(Preimage = CONE['preimage']);
macro(contains_ray = `contains/ray`);
macro(contains_line = `contains/line`);
macro(Dim = CONE['dim']);
macro(zerocone = CONVEX['zerocone']);
macro(fullcone = CONVEX['fullcone']);
macro(affinecone = CONE['`convert/affine`']);
macro(Ispointed = CONE['ispointed']);
macro(succhspacenos = `convex/succhspacenos`);
macro(Relint = CONE['relint']);
macro(posorthant = CONVEX['posorthant']);

macro(NEWPOLYHEDRON = POLYHEDRON['_c2p']);
macro(emptypolyhedron = CONVEX['emptypolyhedron']);
macro(fullpolyhedron = CONVEX['fullpolyhedron']);
macro(lines_polyhedron = `polyhedron/lines`);
macro(Vertices = POLYHEDRON['vertices']);
macro(Isbounded = POLYHEDRON['isbounded']);
macro(affine = `convex/affine`);
macro(homog = `convex/homog`);
macro(homog_1 = `convex/homog_1`);
macro(dehomog = `convex/dehomog`);
macro(origin = `convex/origin`);
macro(Isaffine = `ray/_isaffine`);
macro(affh2ray = `convex/affh2ray`);
macro(mat_homog = `convex/mat/homog`);
macro(convexhull = CONVEX['convhull']);

macro(FAN_maximal_list = FAN['_maximal_list']);
macro(zerofan = CONVEX['zerofan']);
macro(facefan = POLYHEDRON['facefan']);
macro(normalfan = POLYHEDRON['normalfan']);

macro(parsemod = CONVEX['_parsemod']);
