#
# Z-MODULES
#

#
# type MODZ
#

`type/MODZ` := proc(x)
  op(0, x) = OBJ and OBJ_TYPE(x) = 'MODZ'
end;

MODZ[_new] := proc(r::nonnegint, eldiv::list(posint))
  OBJ('MODZ', r, eldiv)
end;

CONVEX[modz] := proc(r::{nonnegint, list(posint)}, eldiv::list(posint))
local _r, _eldiv;
  if nargs > 2
    then ERRORnargs
  elif nargs = 2 and not type(r, nonnegint)
    then ERRORillegalcomb
  fi;

  _r := &?(nargs = 2 or (nargs = 1 and type(r, nonnegint)), r, 0);
  _eldiv := &?(nargs = 2, eldiv,
			  &?(nargs = 1 and type(r, list), r, []));
  MODZ['_new'](_r, MODZ['_normeldiv'](_eldiv))
end;

MODZ[_zero] := MODZ[_new](0, []);

MODZ[_print] := proc(r::integer, eldiv::list(posint))
local i;
  r*'Z'+`+`(seq('Z'[i], i = eldiv))
end;

MODZ[`&=`] := () -> evalb(`=`(args));

MODZ[rank] := proc(M)
  MODZ_rank(M)
end;

MODZ[torsion] := proc(M)
  MODZ_torsion(M)
end;

MODZ[corank] := proc(M)
  MODZ_rank(M)+nops(MODZ_torsion(M))
end;

MODZ[_char] := 0;

MODZ[_normeldiv] := proc(al)
local i, j, d, n, l;
  n := nops(al);
  l := al;
  for i to n-1 do
    for j from i+1 to n do
      d := abs_igcd(igcd(l[i], l[j]));
      l[j] := l[i]*l[j]/d;
      l[i] := d
    od
  od;
  subs(1 = NULL, l)
end;

MODZ[directsum] := proc()
local al;
  al := [args];
  if type(al, list(MODZ))
    then
      MODZ['_new'](`+`(op(map2(op, MODZ_OP_rank, al))),
	           MODZ['_normeldiv'](map(op, map2(op, MODZ_OP_torsion, al))))
    else ERRORtype
  fi
end;

MODZ[_smith] := proc(A::mat)
local B, n, r, i;
  n := mat_nrows(A);
  if n > 0 then n := min(n, mat_ncols(A)) fi;
  if n = 0
    then RETURN([])
  elif type(eval(_Env_ismith), procedure)
    then B := _Env_ismith(A)
  elif type(eval(ismith), procedure)
    then B := ismith(A)
  elif type(eval( LinearAlgebra['SmithForm']), procedure)
    then B := LinearAlgebra['SmithForm'](&?(type(A, Matrix), A, Matrix(A)),
                                         method = integer)
  # is it possible at all that SmithForm is not defined???
    else B := linalg['ismith'](&?(type(A, array), A, convert(A, array)))
  fi;
  if type(B, mat)
    then
      for r to n while B[r, r] <> 0 do od;
      [seq(B[i, i], i = 1..r-1)]
  elif type(B, list(posint))
    then B
    else ERROR("ismith failed")
  fi
end;

MODZ[_homology] := proc(i0::integer, i1::integer, A::Array, d::procedure)
# computes the INTEGRAL homology of a complex between i0 and i1
# A[i] is the rank of the i-th degree
# d returns the differential A[i] -> A[i-1] as {listlist, array, Array}
# d(i) is not called if it must necessarily be the zero map 
local i, eldiv, rk, j;
  for i from i0+1 to i1 do
    if A[i-1] = 0 or A[i] = 0
      then
        A[i-1] := MODZ['_new'](A[i-1], []);
        next
    fi;
    eldiv := MODZ['_smith'](d(i));
    rk := nops(eldiv);
    for j to rk while eldiv[j] = 1 do od;
    A[i-1] := MODZ['_new'](A[i-1]-rk, eldiv[j..-1]);
    A[i]   := A[i]-rk
  od;
  A[i1] := MODZ['_new'](A[i1], []);
  A
end;
