#
# type PCOMPLEX
#

`type/PCOMPLEX` := proc(x)
  op(0, x) = OBJ and op(1, x) = 'PCOMPLEX'
end;

PCOMPLEX[EL] := 'CELL';

PCOMPLEX[SHIFT] := 1;

PCOMPLEX[_print] := proc(d::nonnegint, l, MC)
local n, T;
  T := &?(type(MC, array), MC, table(op(2, MC)));
  # we can't use MC directly, since its type is not `array', but `ARRAY',
  # which must be some sort of display version
  # This doesn't apply if called from the global method handler
  # in case of errors
  if l = []
    then 'PCOMPLEX'(d-1, [seq(nops(T[n]), n = 1..d)])
  elif l <> FAIL
    then 'PCOMPLEX'(d-1, nops(l), [seq(nops(T[n]), n = 1..d)])
    else 'PCOMPLEX'(d-1, FAIL, [seq(nops(T[n]), n = 1..d)])
  fi
end;

PCOMPLEX[lines] := proc(PC)
local l;
  l := FAN_lines(PC);
  if nargs > 1
    then ERRORnargs
  elif l = FAIL
    then l
    else map(affine, FAN_lines(PC))
  fi
end;

PCOMPLEX[vertices] := proc(PC)
  if nargs > 1
    then ERRORnargs
    else map(affine, select(Isaffine, FAN['rays'](PC)))
  fi
end;

PCOMPLEX[rays] := proc(PC)
  if nargs > 1
    then ERRORnargs
    else map(affine, remove(Isaffine, FAN['rays'](PC)))
  fi
end;

PCOMPLEX[hplanes] := proc(PC)
  if nargs > 1
    then ERRORnargs
  elif PCOMPLEX['isempty'](PC)
    then [[0$PCOMPLEX['ambientdim'](PC)] = 1]
    else map(x -> x[1] = -x[2], map(dehomog, FAN['hplanes'](PC)))
  fi
end;

PCOMPLEX[minimal] := proc(PC)
  if nargs > 1
    then ERRORnargs
    else [CELL[NEW](emptypolyhedron(PCOMPLEX['ambientdim'](PC)), PC)]
  fi
end;

PCOMPLEX[isempty] := proc(PC)
  if nargs > 1
    then ERRORnargs
    else evalb(FAN_maximal_array(PC)[0] <> [])
  fi
end;

PCOMPLEX[isbounded] := eval(FAN[issimplicial]);

CONVEX[pcomplex] := eval(CONVEX[fan]);

CONVEX[emptypcomplex] := proc(d::nonnegint)
option remember;
  if nargs > 1
    then ERRORnargs
    else PCOMPLEX['_create']([emptypolyhedron(d)], false)
  fi
end;

PCOMPLEX[`convert/FAN`] := proc(PC)
  if nargs > 1
    then ERRORnargs
  elif Lines(PC) = FAIL
    then ERRORlineality
    else subsop(OBJ_OP_TYPE = 'FAN',
                FAN_OP_maximal_array =
                  map2(map, POLYHEDRON['`convert/CONE`'], FAN_maximal_array(PC)),
                PC)
  fi
end;

`convex/lelim_1` := l -> map(reducevec, map2(subsop, X_1 = NULL, l));

`convex/lelim_2` := proc(l, h)
  map(proc(x) subsop(X_1 = NULL, x-x[X_1]*h) end, l)
end;

`convex/projection_1` := proc(P::{CONE, POLYHEDRON})
# projects P along the last real coordinate X_1
# The resulting PCOMPLEX reflects the bottom of P.
# There must be at least one facet visible from below!
# Facets at infinity are not treated separately.
local d, i, j, ll, rl, eq, ineq, neweq, newineq, h, sat, sat2i, Ps;
  d := Ambientdim(P);
  eq := Hplanes(P);
  ineq := Hspaces(P);
  ll := `convex/lelim_1`(Lines(P));
  # since we use X_1, this is automatically gausselim'ed
  rl := `convex/lelim_1`(Rays(P));
  if exists(x -> x[X_1] <> 0, eq, i)
    then # project the whole polyhedron
      h := eq[i]/eq[i, X_1];
      neweq := `convex/lelim_2`(eq, h);
      newineq := `convex/lelim_2`(ineq, h);
      Ps := NEWPOLYHEDRON(NEWCONE(Ambientdim(P)-1,
                                  ll, rl, Incidentfacets(P),
                                  gausselim(neweq, newineq), Incidentrays(P)))
    else # project the facets visible from below
      sat := Incidentfacets(P);
      neweq := map2(subsop, X_1 = NULL, eq);
      Ps := NULL;
      for i to nops(ineq) do
        if ineq[i, X_1] <= 0
          then next
          else h := ineq[i]/ineq[i, X_1];
        fi;
        newineq := `convex/lelim_2`(ineq, h);
        sat2i := Incidentrays(P)[i];
        Ps := Ps, NEWPOLYHEDRON(reduce(NEWCONE(d-1,
                    ll, [seq(rl[j], j = sat2i)], [seq(sat[j], j = sat2i)],
                    neweq, newineq, [])))
      od;
  fi;
  PCOMPLEX['_create']([Ps], false)
end;

CONVEX[delaunay] := proc()
local al, d, P;
  al := [args];
  if al = []
    then ERRORambientdim_0
  elif not type(al, list(ray))
    then ERRORtype
  fi;
  al := map(convert, al, list);
  if not type(al, listlist)
    then ERRORnotsamespace
  elif METHOD = 'voronoi'
    then al := map(x -> homog_1(-2*x, 1, Dotprod(x, x)), al)
  elif METHOD = 'delaunay'
    then al := map(x -> homog_1(x, Dotprod(x, x), 1), al)
  # METHOD = 'furthestdelaunay'
    else al := map(x -> homog_1(x, -Dotprod(x, x), 1), al)
  fi;
  d := nops(al[1]);
  if METHOD = 'voronoi'
    then P := Intersection(d, [fullpolyhedron(d-1)], [], al)
    else P := Hull(d, [], [], al)
  fi;
  `convex/projection_1`(P)
end;

CONVEX[furthestdelaunay] := eval(CONVEX[delaunay]);

CONVEX[voronoi] := eval(CONVEX[delaunay]);

PCOMPLEX[volume] := proc(PC)
local Pl;
  Pl := FAN_maximal_array(PC)[FAN_ambientdim(PC)];
  if nargs > 1
    then ERRORnargs
  elif andmap(POLYHEDRON['isbounded'], Pl)
    then `+`(op(map(POLYHEDRON['volume'], Pl)))
    else infinity
  fi
end;

# WRONG: doesn't account for internal facets!
#
# PCOMPLEX[surface] := proc(PC)
# local d, MC, Pl, dummy;
#   d := FAN_ambientdim(PC);
#   MC := FAN_maximal_array(PC);
#   Pl := [op(MC[d]), op(MC[d-1])];
#   if nargs > 1
#     then ERRORnargs
#   elif forall(POLYHEDRON['isbounded'], Pl, dummy)
#     then `+`(op(map(POLYHEDRON['surface'], Pl)))
#     else infinity
#   fi
# end;

#
# graphics
#

PCOMPLEX[plotdata] := proc(PC::PCOMPLEX)
local d, opts, MC, P, t, F, vl, vs;
  if nargs > 2
    then ERRORnargs
  elif not PCOMPLEX['isbounded'](PC)
    then ERROR("argument must be bounded")
  fi;
  d := PCOMPLEX['ambientdim'](PC);
  opts := &?(nargs = 2, op(convert(args[2], PLOToptions)), NULL);
  MC := FAN_maximal_array(PC);
  if d = 2
    then t := NULL
  elif d = 3
    then
      t := table();
      for P in MC[3+1] do
        for F in POLYHEDRON['facets'](P) do
          if not PFACE['isbounded'](F) then next fi;
          vl := PFACE['vertices'](F);
          vs := convert(vl, set);
          if assigned(t[vs])
            then t[vs] := 't'[vs]
            else t[vs] := op(vl);
          fi
        od
      od;
      t := entries(t)
    else
      ERRORdim23
  fi;
  POLYGONS(op(map(`convex/orderplanepoints`, [t, op(map(Vertices, MC[2+1]))])),
           opts),
  CURVES(op(map(Vertices, MC[1+1])), opts),
  POINTS(op(map(op, map(Vertices, MC[0+1]))), opts)
end;

PCOMPLEX[draw] := eval(POLYHEDRON[draw]);

#
# copy
#

COPYNEWENTRIES(FAN, PCOMPLEX);
