#
# standard library functions (including macros)
#

macro(`&?` = `if`);

$define exists	`std/exists`
# exists := proc(f, L, j::evaln)
# local fargs, i;
#   fargs := `if`(nargs > 3, args[4..-1], NULL);
#   for i to nops(L) do
#     if f(op(i, L), fargs) then j := i; RETURN(true) fi
#   od;
#   false
# end;
exists := proc(f, L, j::evaln)
local i;
  for i to nops(L) do
    if f(L[i])
      then
        if nargs = 3 then j := i fi;
        RETURN(true)
    fi
  od;
  false
end;

$define forall	`std/forall`
# forall := proc(f, L, j::evaln)
# local fargs, i;
#   fargs := `if`(nargs > 3, args[4..-1], NULL);
#   for i to nops(L) do
#     if not f(op(i, L), fargs) then j := i; RETURN(false) fi
#   od;
#   true
# end;
forall := proc(f, L, j::evaln)
local i;
  for i to nops(L) do
    if not f(L[i])
      then
        if nargs = 3 then j := i fi;
        RETURN(false)
    fi
  od;
  true
end;

# if maple7
#   then
    macro(ormap = exists);
    macro(andmap = forall);
# fi;

macro(findmax = `std/findmax`);
findmax := proc(f::procedure, L::list)
# optional: additional arguments for f
# returns the position of the first element in L which maximises f
# or 0, if the list is empty
local i, imax, max, y;
  imax := 0;
  max := -infinity;
  for i to nops(L) do
    y := f(L[i], args[3..-1]);
    if y > max then imax := i; max := y fi
  od;
  imax
end;

macro(findmin = `std/findmin`);
# finds the minimum of f, applied to the elements in the list L
# x0 receives the first element realising this minimum
# NOTE: the arguments and return value are different from findmax!
findmin := proc(L::{list, set}, f::{procedure,rational}, x0::evaln)
local x, y, y0;
  y0 := infinity;
  for x in L do
    y := f(x);
    if y < y0 then y0 := y; x0 := x; fi
  od;
  y0
end;
