#
# toric stuff
#

# see also: "isregular" and "hilbertbasis" in "cone.mt"

CONVEX[lensspace] := proc(p::posint)
# cone of cone over lens space of order p and weights args[2], ..., args[-1]
option remember;
local al, A, U, c, i;
  al := [args[2..-1]];
  if al = []
    then RETURN(zerocone(0))
  elif not type(al, list(integer))
    then ERRORweights
  fi;
#   A := hermite2(map(x -> [x], al), true, U);
#   hull(op(transpose([p/abs_igcd(igcd(p, A[1, 1]))*U[1], op(2..-1, U)])))
  A := hermite2inv(map(x -> [x], al), true, U);
  U := inverse(U);
  c := p/abs_igcd(igcd(p, A[1, 1]));
  hull(seq([c*U[i, 1], op(2..-1, U[i])], i = 1..nops(U)))
end;

CONVEX[projspace] := proc(n::nonnegint)
# fan of projective space of dimension n
option remember;
  if nargs > 1
    then ERRORnargs
    else facefan(convexhull(op(basiclists(n)), [-1$n]))
  fi
end;

CONVEX[wprojspace] := proc()
# fan of weighted projective space with weights args[1], ..., args[-1]
option remember;
local al, U;
  al := [args];
  if al = [] or not type(al, list(posint))
    then ERRORposint
  elif nops(al) = 1
    then zerofan(0)
    else
#       hermite2(map(x -> [x], al), true, U);
#       facefan(convexhull(op(transpose(U[2..-1]))))
      hermite2inv(map(x -> [x], al), true, U);
      # now U has a value
$ifdef MINT
  U := [];
$endif
      facefan(convexhull(op(map2(subsop, 1 = NULL, inverse(U)))))
  fi;
end;
